/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Bug39819Test
extends CalDAVTest {
    @Test
    public void testSpecialCharacters() throws Exception {
        String uid = Bug39819Test.randomUID();
        Date start = TimeTools.D("next tuesday at 06:00");
        Date end = TimeTools.D("next tuesday at 07:00");
        String summary = "Test \u00fc_\u00f6_\u00e4_\u00fa_\u00ec_\u00f4_\u20ac_\u0160_\u0161_\u017d_\u017e_\u0152_\u0153_\u0178_\u00a4_\u00a6_\u00a8_\u00b4_\u00b8_\u00bc_\u00bd_\u00be";
        String iCal = Bug39819Test.generateICal(start, end, uid, summary, "test");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertEquals((String)"Title wrong", (Object)summary, (Object)appointment.getTitle());
        ICalResource iCalResource = this.get(uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No SUMMARY in iCal found", (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        iCalResource.getVEvent().setLocation("new location");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(iCalResource));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"Title wrong", (Object)summary, (Object)appointment.getTitle());
        Assert.assertEquals((String)"Location wrong", (Object)"new location", (Object)appointment.getLocation());
        iCalResource = this.get(uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No SUMMARY in iCal found", (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertNotNull((String)"No LOCATION in iCal found", (Object)iCalResource.getVEvent().getLocation());
        Assert.assertEquals((String)"LOCATION wrong", (Object)"new location", (Object)iCalResource.getVEvent().getLocation());
    }
}

