/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug39098Test
extends CalDAVTest {
    @Test
    public void testCreateInAsiaShanghai() throws Exception {
        String uid = Bug39098Test.randomUID();
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.10.3//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Asia/Shanghai\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nRRULE:FREQ=YEARLY;UNTIL=19910914T150000Z;BYMONTH=9;BYDAY=3SU\r\nDTSTART:19890917T000000\r\nTZNAME:GMT+8\r\nTZOFFSETTO:+0800\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0800\r\nDTSTART:19910414T000000\r\nTZNAME:GMT+8\r\nTZOFFSETTO:+0900\r\nRDATE:19910414T000000\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:20150629T100123Z\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=Asia/Shanghai:20150630T190000\r\n" + "DTEND;TZID=Asia/Shanghai:20150630T200000\r\n" + "TRANSP:OPAQUE\r\n" + "SUMMARY:test\r\n" + "DTSTAMP:20150629T100123Z\r\n" + "SEQUENCE:0\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        TimeZone userTimeZone = TimeZone.getTimeZone("Asia/Shanghai");
        Calendar calendar = Calendar.getInstance(userTimeZone);
        calendar.set(2015, 5, 30, 19, 0, 0);
        calendar.set(14, 0);
        Date expectedStartDate = calendar.getTime();
        calendar.set(2015, 5, 30, 20, 0, 0);
        Date expectedEndDate = calendar.getTime();
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertEquals((Object)expectedStartDate, (Object)appointment.getStartDate());
        Assert.assertEquals((Object)expectedEndDate, (Object)appointment.getEndDate());
        ICalResource iCalResource = this.get(uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((Object)expectedStartDate, (Object)iCalResource.getVEvent().getDTStart());
        Assert.assertEquals((Object)expectedEndDate, (Object)iCalResource.getVEvent().getDTEnd());
    }
}

