/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Bug25783Test
extends CalDAVTest {
    @Test
    public void testPreserveWhitespaceAtFoldingBoundary() throws Exception {
        String expectedDescription = "- Gesamtaufwaende- Kosten eines Manntags (inklusive allem, von Travel ueber Hotel bis Kopierkosten)\n- Sonstiges";
        String uid = Bug25783Test.randomUID();
        Date start = TimeTools.D("next monday at 12:00");
        Date end = TimeTools.D("next monday at 13:00");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nTRANSP:OPAQUE\r\nDTEND;TZID=Europe/Berlin:" + Bug25783Test.format(end, "Europe/Amsterdam") + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug25783Test.formatAsUTC(new Date()) + "\r\n" + "DESCRIPTION:- Gesamtaufwaende- Kosten eines Manntags (inklusive allem\\," + "\r\n" + "  von Travel ueber Hotel bis Kopierkosten)\\n- Sonstiges" + "\r\n" + "SEQUENCE:3" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:dsvgds" + "\r\n" + "LAST-MODIFIED:20130430T063700Z" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug25783Test.format(start, "Europe/Amsterdam") + "\r\n" + "CREATED:" + Bug25783Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Assert.assertEquals((String)"description wrong", (Object)expectedDescription, (Object)appointment.getNote());
        ICalResource iCalResource = super.get(uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"description wrong", (Object)expectedDescription, (Object)iCalResource.getVEvent().getDescription());
    }
}

