/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug23610Test
extends CalDAVTest {
    @Test
    public void testConfirmAppointment() throws Exception {
        for (int shownAs : new int[]{4, 2, 1, 3}) {
            for (int confirmation : new int[]{1, 2, 3}) {
                this.confirmAppointment(shownAs, confirmation);
            }
        }
    }

    private void confirmAppointment(int appointmentShownAs, int confirmationStatus) throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = Bug23610Test.randomUID();
        String summary = "Bug23610Test-" + appointmentShownAs + "-" + confirmationStatus;
        String location = "test";
        Date start = TimeTools.D("next saturday at 10:00");
        Date end = TimeTools.D("next saturday at 11:00");
        Appointment appointment = Bug23610Test.generateAppointment(start, end, uid, summary, location);
        appointment.setOrganizer("otto@example.com");
        appointment.addParticipant((Participant)new UserParticipant(super.getAJAXClient().getValues().getUserId()));
        ExternalUserParticipant participant = new ExternalUserParticipant("otto@example.com");
        participant.setConfirm(1);
        appointment.addParticipant((Participant)participant);
        appointment.setShownAs(appointmentShownAs);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23610Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        if (null != iCalResource.getVEvent().getTransp()) {
            Assert.assertEquals((String)"TRANSP wrong", (Object)(4 == appointmentShownAs ? "TRANSPARENT" : "OPAQUE"), (Object)iCalResource.getVEvent().getTransp());
        }
        String partstat = 3 == confirmationStatus ? "TENTATIVE" : (2 == confirmationStatus ? "DECLINED" : "ACCEPTED");
        List<SimpleICal.Property> attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            for (Map.Entry<String, String> attribute : property.getAttributes().entrySet()) {
                if (!attribute.getKey().equals("PARTSTAT")) continue;
                attribute.setValue(partstat);
            }
        }
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        UserParticipant[] users = appointment.getUsers();
        Assert.assertNotNull((String)"appointment has no users", (Object)users);
        UserParticipant partipant = null;
        for (UserParticipant user : users) {
            if (this.getAJAXClient().getValues().getUserId() != user.getIdentifier()) continue;
            partipant = user;
            break;
        }
        Assert.assertNotNull((String)"confirming participant not found", partipant);
        Assert.assertEquals((String)"confirmation status wrong", (long)confirmationStatus, (long)partipant.getConfirm());
        Assert.assertEquals((String)"shown as wrong", (long)appointmentShownAs, (long)appointment.getShownAs());
        iCalResource = super.get(uid, iCalResource.getETag());
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        SimpleICal.Property attendee = null;
        attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            attendee = property;
            break;
        }
        Assert.assertNotNull((String)"confirming attendee not found", attendee);
        Assert.assertEquals((String)"partstat status wrong", (Object)partstat, (Object)attendee.getAttribute("PARTSTAT"));
        if (null != iCalResource.getVEvent().getTransp()) {
            Assert.assertEquals((String)"TRANSP wrong", (Object)(4 == appointmentShownAs ? "TRANSPARENT" : "OPAQUE"), (Object)iCalResource.getVEvent().getTransp());
        }
    }
}

