/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug23181Test
extends CalDAVTest {
    private CalendarTestManager manager2;

    @Before
    public void setUp() throws Exception {
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.manager2) {
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
    }

    @Test
    public void testImportAppointment() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String userA = this.client.execute(new GetRequest(Tree.DefaultAddress)).getString();
        String userB = this.manager2.getClient().execute(new GetRequest(Tree.DefaultAddress)).getString();
        String uid = Bug23181Test.randomUID();
        String summary = "Bug23181Test";
        String location = "tbd";
        Date start = TimeTools.D("tomorrow at 3pm");
        Date end = TimeTools.D("tomorrow at 4pm");
        Appointment appointment = Bug23181Test.generateAppointment(start, end, uid, summary, location);
        appointment.setOrganizer("extern1@example.com");
        appointment.addParticipant((Participant)new ExternalUserParticipant("extern2@example.com"));
        appointment.addParticipant((Participant)new ExternalUserParticipant("extern3@example.com"));
        appointment.addParticipant((Participant)new ExternalUserParticipant(userB));
        appointment.setIgnoreConflicts(true);
        appointment.setParentFolderID(this.manager2.getClient().getValues().getPrivateAppointmentFolder());
        appointment.setSequence(0);
        this.manager2.insert(appointment);
        String iCal = "BEGIN:VCALENDAR\r\nMETHOD:REQUEST\r\nPRODID:Microsoft Exchange Server 2007\r\nVERSION:2.0\r\nCALSCALE:GREGORIAN\r\nBEGIN:VEVENT\r\nORGANIZER;CN=Extern 1:MAILTO:extern1@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=Extern 2:MAILTO:extern2@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=Extern 3:MAILTO:extern3@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=" + userB + ":MAILTO:" + userB + "\r\n" + "ATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED;RSVP=TRUE;CN=" + userA + ":MAILTO:" + userA + "\r\n" + "CREATED:" + Bug23181Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND:" + Bug23181Test.formatAsUTC(end) + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:" + summary + "\r\n" + "LOCATION:abcdefg" + "\r\n" + "DTSTAMP:" + Bug23181Test.formatAsUTC(new Date()) + "\r\n" + "DTSTART:" + Bug23181Test.formatAsUTC(start) + "\r\n" + "SEQUENCE:1" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertNotNull((String)"appointment has no users", (Object)appointment.getUsers());
        UserParticipant partipantA = null;
        UserParticipant partipantB = null;
        for (UserParticipant user : appointment.getUsers()) {
            if (this.getAJAXClient().getValues().getUserId() == user.getIdentifier()) {
                partipantA = user;
                continue;
            }
            if (this.manager2.getClient().getValues().getUserId() != user.getIdentifier()) continue;
            partipantB = user;
        }
        Assert.assertNotNull((String)"added user participant not found", partipantA);
        Assert.assertNotNull((String)"previous participant not found", partipantB);
        Assert.assertEquals((String)"confirmation status wrong", (long)1L, (long)partipantA.getConfirm());
        appointment = this.manager2.get(this.manager2.getClient().getValues().getPrivateAppointmentFolder(), appointment.getObjectID());
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertNotNull((String)"appointment has no users", (Object)appointment.getUsers());
        partipantA = null;
        partipantB = null;
        for (UserParticipant user : appointment.getUsers()) {
            if (this.getAJAXClient().getValues().getUserId() == user.getIdentifier()) {
                partipantA = user;
                continue;
            }
            if (this.manager2.getClient().getValues().getUserId() != user.getIdentifier()) continue;
            partipantB = user;
        }
        Assert.assertNotNull((String)"added user participant not found", (Object)partipantA);
        Assert.assertNotNull((String)"previous participant not found", (Object)partipantB);
        Assert.assertEquals((String)"confirmation status wrong", (long)1L, (long)partipantA.getConfirm());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23181Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)appointment.getLocation(), (Object)iCalResource.getVEvent().getLocation());
        SimpleICal.Property attendeeA = null;
        SimpleICal.Property attendeeB = null;
        List<SimpleICal.Property> attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (property.getValue().toLowerCase().contains(super.getAJAXClient().getValues().getDefaultAddress().toLowerCase())) {
                attendeeA = property;
                continue;
            }
            if (!property.getValue().toLowerCase().contains(this.manager2.getClient().getValues().getDefaultAddress().toLowerCase())) continue;
            attendeeB = property;
        }
        Assert.assertNotNull((String)"added user attendee not found", attendeeA);
        Assert.assertNotNull((String)"previous attendee not found", attendeeB);
        Assert.assertEquals((String)"partstat status wrong", (Object)"ACCEPTED", (Object)attendeeA.getAttribute("PARTSTAT"));
    }

    @Test
    public void testDontImportOutSequencedAppointment() throws Exception {
        String userA = CalDAVTest.getLogin(AJAXClient.User.User1);
        String userB = CalDAVTest.getLogin(AJAXClient.User.User2);
        String uid = Bug23181Test.randomUID();
        String summary = "Bug23181Test2";
        String location = "tbd";
        Date start = TimeTools.D("tomorrow at 1pm");
        Date end = TimeTools.D("tomorrow at 2pm");
        Appointment appointment = Bug23181Test.generateAppointment(start, end, uid, summary, location);
        appointment.setOrganizer("extern1@example.com");
        appointment.addParticipant((Participant)new ExternalUserParticipant("extern2@example.com"));
        appointment.addParticipant((Participant)new ExternalUserParticipant("extern3@example.com"));
        appointment.addParticipant((Participant)new ExternalUserParticipant(userB));
        appointment.setIgnoreConflicts(true);
        appointment.setParentFolderID(this.manager2.getClient().getValues().getPrivateAppointmentFolder());
        appointment.setSequence(0);
        this.manager2.insert(appointment);
        String iCal = "BEGIN:VCALENDAR\r\nMETHOD:REQUEST\r\nPRODID:Microsoft Exchange Server 2007\r\nVERSION:2.0\r\nCALSCALE:GREGORIAN\r\nBEGIN:VEVENT\r\nORGANIZER;CN=Extern 1:MAILTO:extern1@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=Extern 2:MAILTO:extern2@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=Extern 3:MAILTO:extern3@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=" + userB + ":MAILTO:" + userB + "\r\n" + "ATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED;RSVP=TRUE;CN=" + userA + ":MAILTO:" + userA + "\r\n" + "CREATED:" + Bug23181Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND:" + Bug23181Test.formatAsUTC(end) + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:" + summary + "\r\n" + "LOCATION:abcdefg" + "\r\n" + "DTSTAMP:" + Bug23181Test.formatAsUTC(new Date()) + "\r\n" + "DTSTART:" + Bug23181Test.formatAsUTC(start) + "\r\n" + "SEQUENCE:0" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)409L, (long)super.putICal(uid, iCal));
    }

    @Test
    public void testDontImportOtherOrganizersAppointment() throws Exception {
        String userA = CalDAVTest.getLogin(AJAXClient.User.User1);
        String userB = CalDAVTest.getLogin(AJAXClient.User.User2);
        String uid = Bug23181Test.randomUID();
        String summary = "Bug23181Test3";
        String location = "tbd";
        Date start = TimeTools.D("tomorrow at 1pm");
        Date end = TimeTools.D("tomorrow at 2pm");
        Appointment appointment = Bug23181Test.generateAppointment(start, end, uid, summary, location);
        appointment.setOrganizer("extern1@example.com");
        appointment.addParticipant((Participant)new ExternalUserParticipant("extern2@example.com"));
        appointment.addParticipant((Participant)new ExternalUserParticipant("extern3@example.com"));
        appointment.addParticipant((Participant)new ExternalUserParticipant(userB));
        appointment.setIgnoreConflicts(true);
        appointment.setParentFolderID(this.manager2.getClient().getValues().getPrivateAppointmentFolder());
        appointment.setSequence(0);
        this.manager2.insert(appointment);
        String iCal = "BEGIN:VCALENDAR\r\nMETHOD:REQUEST\r\nPRODID:Microsoft Exchange Server 2007\r\nVERSION:2.0\r\nCALSCALE:GREGORIAN\r\nBEGIN:VEVENT\r\nORGANIZER;CN=Extern 1:MAILTO:extern4@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=Extern 2:MAILTO:extern2@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=Extern 3:MAILTO:extern3@example.com\r\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=" + userB + ":MAILTO:" + userB + "\r\n" + "ATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=ACCEPTED;RSVP=TRUE;CN=" + userA + ":MAILTO:" + userA + "\r\n" + "CREATED:" + Bug23181Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND:" + Bug23181Test.formatAsUTC(end) + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:" + summary + "\r\n" + "LOCATION:abcdefg" + "\r\n" + "DTSTAMP:" + Bug23181Test.formatAsUTC(new Date()) + "\r\n" + "DTSTART:" + Bug23181Test.formatAsUTC(start) + "\r\n" + "SEQUENCE:1" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)409L, (long)super.putICal(uid, iCal));
    }
}

