/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ICALFixtures {
    private final SimpleDateFormat dateTime = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private final SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");

    public ICALFixtures() {
        this.dateTime.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String veventWithLocalDTStartAndDTEnd(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        this.localDTStartAndDTEnd(bob, start, end);
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    private void localDTStartAndDTEnd(StringBuilder bob, Date start, Date end) {
        bob.append("DTSTART:").append(this.dateTime.format(start)).append('\n');
        bob.append("DTEND:").append(this.dateTime.format(end)).append('\n');
    }

    private void localDTStartAndDue(StringBuilder bob, Date start, Date end) {
        bob.append("DTSTART:").append(this.dateTime.format(start)).append('\n');
        bob.append("DUE:").append(this.dateTime.format(end)).append('\n');
    }

    public String veventWithUTCDTStartAndDTEnd(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        this.utcDTStartAndDTEnd(bob, start, end);
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    private void utcDTStartAndDTEnd(StringBuilder bob, Date start, Date end) {
        bob.append("DTSTART:").append(this.dateTime.format(start)).append("Z\n");
        bob.append("DTEND:").append(this.dateTime.format(end)).append("Z\n");
    }

    private void utcDTStartAndDue(StringBuilder bob, Date start, Date end) {
        bob.append("DTSTART:").append(this.dateTime.format(start)).append("Z\n");
        bob.append("DUE:").append(this.dateTime.format(end)).append("Z\n");
    }

    public String veventWithDTStartAndEndInTimeZone(Date start, Date end, TimeZone timeZone) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        this.timezoneDTStartAndDTEnd(bob, start, end, timeZone.getID());
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String veventWithDTStartAndEndInTimeZone(Date start, Date end, String timeZone) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        this.timezoneDTStartAndDTEnd(bob, start, end, timeZone);
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    private void timezoneDTStartAndDTEnd(StringBuilder bob, Date start, Date end, String timeZone) {
        bob.append("DTSTART;TZID=").append(timeZone).append(':').append(this.dateTime.format(start)).append('\n');
        bob.append("DTEND;TZID=").append(timeZone).append(':').append(this.dateTime.format(end)).append('\n');
    }

    private void timezoneDTStartAndDue(StringBuilder bob, Date start, Date end, String timeZone) {
        bob.append("DTSTART;TZID=").append(timeZone).append(':').append(this.dateTime.format(start)).append('\n');
        bob.append("DUE;TZID=").append(timeZone).append(':').append(this.dateTime.format(end)).append('\n');
    }

    public String veventWithDTStartAndDTEndInCustomTimezone(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.addTimeZone(bob);
        this.beginEvent(bob);
        this.customTimezoneDTStartAndDTEnd(bob, start, end);
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    private void customTimezoneDTStartAndDTEnd(StringBuilder bob, Date start, Date end) {
        bob.append("DTSTART;TZID=").append("/custom/Japan").append(':').append(this.dateTime.format(start)).append('\n');
        bob.append("DTEND;TZID=").append("/custom/Japan").append(':').append(this.dateTime.format(end)).append('\n');
    }

    private void customTimezoneDTStartAndDue(StringBuilder bob, Date start, Date end) {
        bob.append("DTSTART;TZID=").append("/custom/Japan").append(':').append(this.dateTime.format(start)).append('\n');
        bob.append("DUE;TZID=").append("/custom/Japan").append(':').append(this.dateTime.format(end)).append('\n');
    }

    public String veventWithLocalDTStartAndDuration(Date start, String duration) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        bob.append("DTSTART:").append(this.dateTime.format(start)).append('\n');
        bob.append("DURATION:").append(duration).append('\n');
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String veventWithSimpleProperties(Date start, Date end, String ... properties) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i++];
            String value = properties[i];
            bob.append(name).append(':').append(value).append('\n');
        }
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithAttendees(Date start, Date end, String[] mails) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        for (String mail : mails) {
            bob.append("ATTENDEE:MAILTO:").append(mail).append('\n');
        }
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithResources(Date start, Date end, String[] resources) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        bob.append("RESOURCES:");
        for (String resource : resources) {
            bob.append(resource).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithResourcesInAttendees(Date start, Date end, String[] resources) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        for (String cn : resources) {
            bob.append("ATTENDEE;CUTYPE=RESOURCE;CN=").append(cn).append(":MAILTO:ignored@bla.invalid\n");
        }
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithCategories(Date start, Date end, String[] categories) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        bob.append("CATEGORIES:");
        for (String category : categories) {
            bob.append(category).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithDeleteExceptionsAsDateTime(Date start, Date end, String rrule, Date[] exceptions) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        bob.append("RRULE:").append(rrule).append('\n');
        bob.append("EXDATE:");
        for (Date exception : exceptions) {
            bob.append(this.dateTime.format(exception)).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithDeleteExceptionsAsDate(Date start, Date end, String rrule, Date[] exceptions) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        bob.append("RRULE:").append(rrule).append('\n');
        bob.append("EXDATE;VALUE=DATE:");
        for (Date exception : exceptions) {
            bob.append(this.date.format(exception)).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithDisplayAlarm(Date start, Date end, String trigger, String description) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        bob.append("BEGIN:VALARM\n");
        bob.append(trigger).append('\n');
        bob.append("ACTION:DISPLAY\n");
        bob.append("DESCRIPTION:").append(description).append('\n');
        bob.append("END:VALARM\n");
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    private void standardAppFields(StringBuilder bob, Date start, Date end) {
        this.beginCalendar(bob);
        this.beginEvent(bob);
        bob.append("DTSTART:").append(this.dateTime.format(start)).append("Z\n");
        bob.append("DTEND:").append(this.dateTime.format(end)).append("Z\n");
    }

    private void endStandardAppFields(StringBuilder bob) {
        this.endEvent(bob);
        this.endCalendar(bob);
    }

    private void addTimeZone(StringBuilder bob) {
        bob.append("BEGIN:VTIMEZONE\n");
        bob.append("TZID:/custom/Japan\n");
        bob.append("BEGIN:STANDARD\n");
        bob.append("TZOFFSETFROM:+0900\n");
        bob.append("TZOFFSETTO:+0900\n");
        bob.append("TZNAME:JST\n");
        bob.append("DTSTART:19700101T000000\n");
        bob.append("END:STANDARD\n");
        bob.append("END:VTIMEZONE\n");
    }

    private void beginCalendar(StringBuilder bob) {
        bob.append("BEGIN:VCALENDAR\n").append("VERSION:2.0\n");
    }

    private void beginEvent(StringBuilder bob) {
        bob.append("BEGIN:VEVENT\n");
    }

    private void endEvent(StringBuilder bob) {
        bob.append("END:VEVENT\n");
    }

    private void endCalendar(StringBuilder bob) {
        bob.append("END:VCALENDAR\n");
    }

    private void standardTodoFields(StringBuilder bob) {
        bob.append("BEGIN:VCALENDAR\nBEGIN:VTODO\n");
    }

    private void endStandardTodoFields(StringBuilder bob) {
        bob.append("END:VTODO\nEND:VCALENDAR");
    }

    private void endTodo(StringBuilder bob) {
        bob.append("END:VTODO\n");
    }

    private void beginTodo(StringBuilder bob) {
        bob.append("BEGIN:VTODO\n");
    }

    public String vtodoWithSimpleProperties(String ... properties) {
        StringBuilder bob = new StringBuilder();
        this.standardTodoFields(bob);
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i++];
            String value = properties[i];
            bob.append(name).append(':').append(value).append('\n');
        }
        this.endStandardTodoFields(bob);
        return bob.toString();
    }

    public String vtodoWithLocalDTStartAndDue(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.localDTStartAndDue(bob, start, end);
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithUTCDTStartAndDue(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.utcDTStartAndDue(bob, start, end);
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDTStartAndDueInTimeZone(Date start, Date end, TimeZone timeZone) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.timezoneDTStartAndDue(bob, start, end, timeZone.getID());
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDTStartAndDueInCustomTimezone(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.addTimeZone(bob);
        this.beginTodo(bob);
        this.customTimezoneDTStartAndDue(bob, start, end);
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithLocalDTStartAndDuration(Date start, String duration) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        bob.append("DTSTART:").append(this.dateTime.format(start)).append('\n');
        bob.append("DURATION:").append(duration).append('\n');
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithAttendees(String[] mails) {
        StringBuilder bob = new StringBuilder();
        this.standardTodoFields(bob);
        for (String mail : mails) {
            bob.append("ATTENDEE:MAILTO:").append(mail).append('\n');
        }
        this.endStandardTodoFields(bob);
        return bob.toString();
    }

    public String vtodoWithCategories(String[] categories) {
        StringBuilder bob = new StringBuilder();
        this.standardTodoFields(bob);
        bob.append("CATEGORIES:");
        for (String category : categories) {
            bob.append(category).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endStandardTodoFields(bob);
        return bob.toString();
    }

    public String vtodoWithSimpleProperties(Date start, Date end, String ... properties) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.utcDTStartAndDTEnd(bob, start, end);
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i++];
            String value = properties[i];
            bob.append(name).append(':').append(value).append('\n');
        }
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDeleteExceptionsAsDateTime(Date start, Date end, String rrule, Date[] exceptions) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.utcDTStartAndDTEnd(bob, start, end);
        bob.append("RRULE:").append(rrule).append('\n');
        bob.append("EXDATE:");
        for (Date exception : exceptions) {
            bob.append(this.dateTime.format(exception)).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDeleteExceptionsAsDate(Date start, Date end, String rrule, Date[] exceptions) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.utcDTStartAndDTEnd(bob, start, end);
        bob.append("RRULE:").append(rrule).append('\n');
        bob.append("EXDATE;VALUE=DATE:");
        for (Date exception : exceptions) {
            bob.append(this.date.format(exception)).append(',');
        }
        bob.setCharAt(bob.length() - 1, '\n');
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDisplayAlarm(Date start, Date end, String trigger, String description) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        this.utcDTStartAndDue(bob, start, end);
        bob.append("BEGIN:VALARM\n");
        bob.append(trigger).append('\n');
        bob.append("ACTION:DISPLAY\n");
        bob.append("DESCRIPTION:").append(description).append('\n');
        bob.append("END:VALARM\n");
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDueDate(Date due) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        bob.append("DUE:").append(this.dateTime.format(due)).append("Z\n");
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDueDateWithoutTZ(Date due) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        bob.append("DUE;VALUE=DATE:").append(this.date.format(due)).append('\n');
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String vtodoWithDateCompleted(Date dateCompleted) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginTodo(bob);
        bob.append("COMPLETED:").append(this.dateTime.format(dateCompleted)).append("Z\n");
        this.endTodo(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String veventWithEnd(Date date) {
        return this.veventWithOneDate("DTEND", date);
    }

    public String veventWithStart(Date date) {
        return this.veventWithOneDate("DTSTART", date);
    }

    private String veventWithOneDate(String property, Date date) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        bob.append(property).append(':').append(this.dateTime.format(date)).append('\n');
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String veventWithUnspecifiedVTimeZone(Date start, Date end) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        this.customTimezoneDTStartAndDTEnd(bob, start, end);
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String veventWithTwoRecurrences(Date start, Date end) {
        return this.veventWithSimpleProperties(start, end, "RRULE", "FREQ=DAILY;INTERVAL=1;COUNT=3", "RRULE", "FREQ=DAILY;INTERVAL=2;COUNT=6");
    }

    public String veventWithAudioAlarm(Date start, Date end, String trigger, String audioFile) {
        StringBuilder bob = new StringBuilder();
        this.standardAppFields(bob, start, end);
        bob.append("BEGIN:VALARM\n");
        bob.append(trigger).append('\n');
        bob.append("ACTION:AUDIO\n");
        bob.append("ATTACH:").append(audioFile).append('\n');
        bob.append("END:VALARM\n");
        this.endStandardAppFields(bob);
        return bob.toString();
    }

    public String veventWithWholeDayEvent(Date start) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        bob.append("DTSTART;VALUE=DATE:").append(this.date.format(start)).append('\n');
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String veventWithDTStartAsDateWithoutValue(Date start) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        this.beginEvent(bob);
        bob.append("DTSTART:").append(this.date.format(start)).append('\n');
        this.endEvent(bob);
        this.endCalendar(bob);
        return bob.toString();
    }

    public String severalVevents(int amount) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        for (int i = 0; i < amount; ++i) {
            this.beginEvent(bob);
            bob.append("DTSTART:").append(this.date.format(new Date())).append('\n');
            bob.append("SUMMARY:").append("Appointment #" + i).append('\n');
            this.endEvent(bob);
        }
        this.endCalendar(bob);
        return bob.toString();
    }

    public String severalVtodos(int amount) {
        StringBuilder bob = new StringBuilder();
        this.beginCalendar(bob);
        for (int i = 0; i < amount; ++i) {
            this.beginTodo(bob);
            bob.append("SUMMARY:").append("Task #" + i).append('\n');
            this.endTodo(bob);
        }
        this.endCalendar(bob);
        return bob.toString();
    }
}

