/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.user.UserImpl4Test;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.user.json.parser.UserParser;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetParser
extends AbstractAJAXParser<GetResponse> {
    private final TimeZone timeZone;
    private final int userId;

    GetParser(boolean failOnError, int userId, TimeZone timeZone) {
        super(failOnError);
        this.userId = userId;
        this.timeZone = timeZone;
    }

    @Override
    protected GetResponse createResponse(Response response) {
        return new GetResponse(response);
    }

    @Override
    public GetResponse parse(String body) throws JSONException {
        GetResponse retval = (GetResponse)((Object)super.parse(body));
        if (!retval.hasError() && null != retval.getData()) {
            try {
                JSONObject data = (JSONObject)retval.getData();
                Contact contact = UserParser.parseUserContact((JSONObject)data, (TimeZone)this.timeZone);
                retval.setContact(contact);
                UserImpl4Test user = new UserImpl4Test();
                user.setId(this.userId);
                user.setDisplayName(contact.getDisplayName());
                user.setGivenName(contact.getGivenName());
                user.setSurname(contact.getSurName());
                user.setMail(contact.getEmail1());
                JSONArray jGroups = data.optJSONArray("groups");
                if (jGroups != null) {
                    int[] groups = new int[jGroups.length()];
                    for (int i = 0; i < jGroups.length(); ++i) {
                        groups[i] = jGroups.getInt(i);
                    }
                    user.setGroups(groups);
                }
                retval.setUser(user);
            }
            catch (OXException e) {
                throw new JSONException((Throwable)e);
            }
        }
        return retval;
    }
}

