/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug32044Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private AJAXClient client2;
    private TimeZone timeZone1;
    private TimeZone timeZone2;
    private Calendar cal;
    private Task task;
    private FolderObject folder1;
    private FolderObject folder2;

    public Bug32044Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.timeZone1 = this.client1.getValues().getTimeZone();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.timeZone2 = this.client2.getValues().getTimeZone();
        this.cal = TimeTools.createCalendar(TimeZones.UTC);
        this.folder1 = Create.createPrivateFolder("test for bug 32044 folder 1", 1, this.client1.getValues().getUserId(), Create.ocl(this.client2.getValues().getUserId(), false, false, 2, 4, 4, 4));
        this.folder1.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        CommonInsertResponse response = this.client1.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, this.folder1));
        this.folder1.setObjectID(response.getId());
        this.folder1.setLastModified(response.getTimestamp());
        this.folder2 = Create.createPrivateFolder("test for bug 32044 folder 2", 1, this.client1.getValues().getUserId(), new OCLPermission[0]);
        this.folder2.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        response = this.client1.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, this.folder2));
        this.folder2.setObjectID(response.getId());
        this.folder2.setLastModified(response.getTimestamp());
        this.task = new Task();
        this.task.setParentFolderID(this.folder1.getObjectID());
        this.task.setTitle("Test for bug 32044");
        this.cal.set(11, 0);
        this.task.setStartDate(this.cal.getTime());
        this.cal.add(5, 1);
        this.task.setEndDate(this.cal.getTime());
        this.cal.setTimeInMillis(System.currentTimeMillis());
        this.cal.add(11, 1);
        this.task.setAlarm(this.cal.getTime());
        this.client1.execute(new InsertRequest(this.task, this.timeZone1)).fillTask(this.task);
        Task addReminder = new Task();
        addReminder.setObjectID(this.task.getObjectID());
        addReminder.setLastModified(this.task.getLastModified());
        addReminder.setParentFolderID(this.task.getParentFolderID());
        addReminder.setAlarm(this.cal.getTime());
        UpdateResponse updateResponse = this.client2.execute(new UpdateRequest(addReminder, this.timeZone2));
        this.task.setLastModified(updateResponse.getTimestamp());
        this.cal.add(11, 1);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.task = this.client1.execute(new GetRequest(this.task)).getTask(this.timeZone1);
        this.client1.execute(new DeleteRequest(this.task));
        GetResponse response = this.client1.execute(new com.openexchange.ajax.folder.actions.GetRequest((API)EnumAPI.OX_OLD, this.folder2.getObjectID(), false));
        if (!response.hasError()) {
            this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.folder2));
        }
        if (!(response = this.client1.execute(new com.openexchange.ajax.folder.actions.GetRequest((API)EnumAPI.OX_OLD, this.folder1.getObjectID(), false))).hasError()) {
            this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.folder1));
        }
        this.client2.logout();
        super.tearDown();
    }

    @Test
    public void testForRemovedReminder() throws OXException, IOException, JSONException {
        RangeResponse rangeResponse = this.client2.execute(new RangeRequest(this.cal.getTime()));
        boolean found = false;
        for (ReminderObject reminder : rangeResponse.getReminder(this.timeZone2)) {
            if (reminder.getModule() != 4 || reminder.getTargetId() != this.task.getObjectID() || reminder.getFolder() != this.folder1.getObjectID()) continue;
            found = true;
            break;
        }
        Bug32044Test.assertTrue((String)"User 2 can not see his own set reminder.", (boolean)found);
        Task move = com.openexchange.groupware.tasks.Create.cloneForUpdate(this.task);
        move.setParentFolderID(this.folder2.getObjectID());
        UpdateResponse response = this.client1.execute(new UpdateRequest(this.folder1.getObjectID(), move, this.timeZone1));
        this.task.setLastModified(response.getTimestamp());
        this.task.setParentFolderID(this.folder2.getObjectID());
        rangeResponse = this.client2.execute(new RangeRequest(this.cal.getTime(), false));
        if (rangeResponse.hasError()) {
            Bug32044Test.fail((String)("Reminder must be removed for second user after moving task into a not visible folder: " + rangeResponse.getErrorMessage()));
        }
        found = false;
        for (ReminderObject reminder : rangeResponse.getReminder(this.timeZone2)) {
            if (reminder.getModule() != 4 || reminder.getTargetId() != this.task.getObjectID() || reminder.getFolder() != this.folder1.getObjectID()) continue;
            found = true;
            break;
        }
        Bug32044Test.assertFalse((String)"User 2 should not have a reminder for the task anymore after moving it to a not visible folder.", (boolean)found);
    }
}

