/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug14002Test
extends AbstractTaskTest {
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private Task task;

    public Bug14002Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.folderId, "Bug 14002 test task");
        this.task.setPercentComplete(0);
        InsertResponse insertR = this.client.execute(new InsertRequest(this.task, this.tz));
        insertR.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testPercentageComplete() throws OXException, IOException, SAXException, JSONException, OXException {
        GetRequest request = new GetRequest(this.task.getParentFolderID(), this.task.getObjectID());
        GetResponse response = this.client.execute(request);
        Task toTest = response.getTask(this.tz);
        Bug14002Test.assertTrue((String)"Percentage complete is missing.", (boolean)toTest.containsPercentComplete());
        Bug14002Test.assertEquals((String)"Percentage complete has wrong value.", (int)this.task.getPercentComplete(), (int)toTest.getPercentComplete());
        ListIDs ids = ListIDs.l(new int[][]{{this.task.getParentFolderID(), this.task.getObjectID()}});
        ListRequest request2 = new ListRequest(ids, new int[]{301});
        CommonListResponse response2 = this.client.execute(request2);
        Object percentage = response2.getValue(0, 301);
        Bug14002Test.assertNotNull((String)"Percentage complete is missing.", (Object)percentage);
        Bug14002Test.assertEquals((String)"Percentage complete has wrong value.", (int)this.task.getPercentComplete(), (int)((Integer)percentage));
    }
}

