/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequestNew;
import com.openexchange.ajax.folder.actions.GetResponseNew;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.folderstorage.Folder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;

public class FolderItemCountTest
extends ShareTest {
    public FolderItemCountTest(String name) {
        super(name);
    }

    public void testFolderItemCount() throws Exception {
        OCLGuestPermission guestPermission = FolderItemCountTest.randomGuestPermission(8);
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8), guestPermission);
        int count = random.nextInt(10);
        for (int i = 0; i < count; ++i) {
            this.insertFile(folder.getObjectID());
        }
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        FolderItemCountTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        FolderItemCountTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, folder.getObjectID(), matchingPermission.getEntity());
        FolderItemCountTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        GetRequestNew req = new GetRequestNew(EnumAPI.OX_NEW, guestClient.getFolder(), new int[]{1, 2, 3, 4, 5, 6, 20, 300, 301, 302, 309});
        GetResponseNew res = guestClient.execute(req);
        Folder fo = res.getFolder();
        FolderItemCountTest.assertEquals((int)count, (int)fo.getTotal());
    }
}

