/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonDeleteParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.Params;
import com.openexchange.share.recipient.AnonymousRecipient;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateRecipientRequest
implements AJAXRequest<AbstractAJAXResponse> {
    private final boolean failOnError;
    private final AnonymousRecipient recipient;
    private final int entity;

    public UpdateRecipientRequest(int entity, AnonymousRecipient recipient, boolean failOnError) {
        this.entity = entity;
        this.failOnError = failOnError;
        this.recipient = recipient;
    }

    public UpdateRecipientRequest(int entity, AnonymousRecipient recipient) {
        this(entity, recipient, true);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public String getServletPath() {
        return "/ajax/share/management";
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new Params("action", "updateRecipient", "entity", String.valueOf(this.entity)).toArray();
    }

    public CommonDeleteParser getParser() {
        return new CommonDeleteParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)this.recipient.getType().toString().toLowerCase());
        jsonObject.put("password", (Object)this.recipient.getPassword());
        jsonObject.put("bits", this.recipient.getBits());
        return jsonObject;
    }

    @Override
    public Header[] getHeaders() {
        return new Header[0];
    }
}

