/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.parser.ContactParser;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Enums;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExtendedPermissionEntity {
    private final Contact contact;
    private final int entity;
    private final RecipientType type;
    private final String displayName;
    private final int bits;
    private final String shareURL;
    private final String password;
    private final Date expiry;

    public static List<ExtendedPermissionEntity> parse(JSONArray json, TimeZone timeZone) throws JSONException {
        if (null == json) {
            return null;
        }
        ArrayList<ExtendedPermissionEntity> entities = new ArrayList<ExtendedPermissionEntity>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            entities.add(new ExtendedPermissionEntity(json.getJSONObject(i), timeZone));
        }
        return entities;
    }

    public ExtendedPermissionEntity(JSONObject json, TimeZone timeZone) throws JSONException {
        JSONObject jsonContact = json.optJSONObject("contact");
        if (null != jsonContact) {
            this.contact = new Contact();
            try {
                new ContactParser().parse(this.contact, jsonContact);
            }
            catch (OXException e) {
                throw new JSONException((Throwable)e);
            }
        } else {
            this.contact = null;
        }
        this.entity = json.optInt("entity");
        this.type = (RecipientType)Enums.parse(RecipientType.class, (String)json.getString("type"));
        this.shareURL = json.optString("share_url", null);
        this.displayName = json.optString("display_name", null);
        this.password = json.optString("password", null);
        this.bits = json.getInt("bits");
        if (json.hasAndNotNull("expiry_date")) {
            long date = json.getLong("expiry_date");
            if (null != timeZone) {
                date -= (long)timeZone.getOffset(date);
            }
            this.expiry = new Date(date);
        } else {
            this.expiry = null;
        }
    }

    public int getEntity() {
        return this.entity;
    }

    public Contact getContact() {
        return this.contact;
    }

    public RecipientType getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getBits() {
        return this.bits;
    }

    public String getShareURL() {
        return this.shareURL;
    }

    public String getPassword() {
        return this.password;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public OCLPermission toFolderPermission(int folderID) {
        OCLPermission permission = new OCLPermission(this.entity, folderID);
        permission.setGroupPermission(RecipientType.GROUP.equals((Object)this.type));
        int[] permissionBits = Permissions.parsePermissionBits((int)this.bits);
        permission.setAllPermission(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3]);
        permission.setFolderAdmin(0 < permissionBits[4]);
        return permission;
    }

    public FileStorageObjectPermission toObjectPermission() {
        return new DefaultFileStorageObjectPermission(this.entity, RecipientType.GROUP.equals((Object)this.type), this.bits);
    }
}

