/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.FileShare;
import com.openexchange.ajax.share.actions.FileSharesRequest;
import com.openexchange.ajax.share.actions.FolderShare;
import com.openexchange.ajax.share.actions.FolderSharesRequest;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.ajax.share.actions.ShareLink;
import com.openexchange.ajax.share.actions.StartSMTPRequest;
import com.openexchange.ajax.share.actions.StopSMTPRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageGuestObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.java.util.TimeZones;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.notification.ShareNotificationService;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.RecipientType;
import com.openexchange.share.recipient.ShareRecipient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.json.JSONException;
import org.junit.Assert;

public abstract class ShareTest
extends AbstractAJAXSession {
    protected static final OCLGuestPermission[] TESTED_PERMISSIONS = new OCLGuestPermission[]{ShareTest.createNamedAuthorPermission("otto@example.com", "Otto Example", "secret"), ShareTest.createNamedGuestPermission("horst@example.com", "Horst Example", "secret"), ShareTest.createAnonymousGuestPermission("secret"), ShareTest.createAnonymousGuestPermission()};
    protected static final FileStorageGuestObjectPermission[] TESTED_OBJECT_PERMISSIONS = new FileStorageGuestObjectPermission[]{ShareTest.asObjectPermission(TESTED_PERMISSIONS[0]), ShareTest.asObjectPermission(TESTED_PERMISSIONS[1]), ShareTest.asObjectPermission(TESTED_PERMISSIONS[2]), ShareTest.asObjectPermission(TESTED_PERMISSIONS[3])};
    protected static final EnumAPI[] TESTED_FOLDER_APIS = new EnumAPI[]{EnumAPI.OX_OLD, EnumAPI.OX_NEW, EnumAPI.OUTLOOK};
    protected static final int[] TESTED_MODULES = new int[]{3, 8, 1, 2};
    protected static final Random random = new Random();
    protected static final int CLEANUP_DELAY = 30000;
    private Map<Integer, FolderObject> foldersToDelete;
    private Map<String, File> filesToDelete;

    protected ShareTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.foldersToDelete = new HashMap<Integer, FolderObject>();
        this.filesToDelete = new HashMap<String, File>();
        StartSMTPRequest startSMTPRequest = new StartSMTPRequest();
        startSMTPRequest.setUpdateNoReplyForContext(this.client.getValues().getContextId());
        this.client.execute(startSMTPRequest);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.client) {
            this.client.execute(new StopSMTPRequest());
            ShareTest.deleteFoldersSilently(this.client, this.foldersToDelete);
            ShareTest.deleteFilesSilently(this.client, this.filesToDelete.values());
        }
        super.tearDown();
    }

    protected TimeZone getTimeZone() throws OXException, IOException, JSONException {
        return this.client.getValues().getTimeZone();
    }

    protected ShareLink getLink(ShareTarget target) throws OXException, IOException, JSONException {
        GetLinkResponse response = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        ShareTest.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        return response.getShareLink();
    }

    protected FolderObject insertSharedFolder(EnumAPI api, int module, int parent, OCLPermission permission) throws Exception {
        return this.insertSharedFolder(api, module, parent, ShareTest.randomUID(), permission);
    }

    protected FolderObject insertSharedFolder(EnumAPI api, int module, int parent, String name, OCLPermission permission) throws Exception {
        FolderObject sharedFolder = Create.createPrivateFolder(name, module, this.client.getValues().getUserId(), permission);
        sharedFolder.setParentFolderID(parent);
        return this.insertFolder(api, sharedFolder);
    }

    protected FolderObject insertSharedFolder(EnumAPI api, int module, int parent, String name, OCLPermission[] permissions) throws Exception {
        FolderObject sharedFolder = Create.createPrivateFolder(name, module, this.client.getValues().getUserId(), permissions);
        sharedFolder.setParentFolderID(parent);
        return this.insertFolder(api, sharedFolder);
    }

    protected FolderObject insertPrivateFolder(EnumAPI api, int module, int parent, String name) throws Exception {
        FolderObject createdFolder = ShareTest.insertPrivateFolder(this.client, api, module, parent, name);
        ShareTest.assertNotNull((Object)createdFolder);
        this.remember(createdFolder);
        ShareTest.assertEquals((String)"Folder name wrong", (String)name, (String)createdFolder.getFolderName());
        return createdFolder;
    }

    protected static FolderObject insertPrivateFolder(AJAXClient client, EnumAPI api, int module, int parent, String name) throws Exception {
        FolderObject privateFolder = Create.createPrivateFolder(name, module, client.getValues().getUserId(), new OCLPermission[0]);
        privateFolder.setParentFolderID(parent);
        return ShareTest.insertFolder(client, api, privateFolder);
    }

    protected FolderObject insertPrivateFolder(EnumAPI api, int module, int parent) throws Exception {
        return this.insertPrivateFolder(api, module, parent, ShareTest.randomUID());
    }

    protected static FolderObject insertPrivateFolder(AJAXClient client, EnumAPI api, int module, int parent) throws Exception {
        return ShareTest.insertPrivateFolder(client, api, module, parent, ShareTest.randomUID());
    }

    protected int getPublicRoot(int module) {
        return 8 == module ? 15 : 2;
    }

    protected FolderObject insertPublicFolder(EnumAPI api, int module) throws Exception {
        FolderObject folder = new FolderObject();
        folder.setFolderName(ShareTest.randomUID());
        folder.setModule(module);
        folder.setType(2);
        OCLPermission perm1 = new OCLPermission();
        perm1.setEntity(this.client.getValues().getUserId());
        perm1.setGroupPermission(false);
        perm1.setFolderAdmin(true);
        perm1.setAllPermission(128, 128, 128, 128);
        folder.setPermissionsAsArray(new OCLPermission[]{perm1});
        folder.setParentFolderID(this.getPublicRoot(module));
        InsertRequest request = new InsertRequest((API)EnumAPI.OX_OLD, folder, true);
        request.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse response = this.client.execute(request);
        response.fillObject((DataObject)folder);
        return folder;
    }

    protected File insertFile(int folderID) throws Exception {
        return this.insertFile(folderID, ShareTest.randomUID());
    }

    protected File insertSharedFile(int folderID, FileStorageObjectPermission guestPermission) throws Exception {
        return this.insertSharedFile(folderID, ShareTest.randomUID(), guestPermission);
    }

    protected File insertFile(int folderID, String filename) throws Exception {
        return this.insertSharedFile(folderID, filename, null);
    }

    protected File insertSharedFile(int folderID, String filename, FileStorageObjectPermission permission) throws Exception {
        byte[] contents = new byte[64 + random.nextInt(256)];
        random.nextBytes(contents);
        return this.insertSharedFile(folderID, filename, permission, contents);
    }

    protected File insertSharedFile(int folderID, String filename, FileStorageObjectPermission permission, byte[] data) throws Exception {
        return this.insertSharedFile(folderID, filename, null == permission ? null : Collections.singletonList(permission), data);
    }

    protected File insertSharedFile(int folderID, String filename, List<FileStorageObjectPermission> permissions, byte[] data) throws Exception {
        DefaultFile metadata = new DefaultFile();
        metadata.setFolderId(String.valueOf(folderID));
        metadata.setFileName(filename);
        if (null != permissions) {
            metadata.setObjectPermissions(permissions);
        }
        NewInfostoreRequest newRequest = new NewInfostoreRequest((File)metadata, new ByteArrayInputStream(data));
        newRequest.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        NewInfostoreResponse newResponse = this.getClient().execute(newRequest);
        String id = newResponse.getID();
        metadata.setId(id);
        GetInfostoreRequest getRequest = new GetInfostoreRequest(id);
        GetInfostoreResponse getResponse = this.client.execute(getRequest);
        File createdFile = getResponse.getDocumentMetadata();
        ShareTest.assertNotNull((Object)createdFile);
        this.remember(createdFile);
        return createdFile;
    }

    protected FolderObject updateFolder(EnumAPI api, FolderObject folder) throws Exception {
        return this.updateFolder(api, folder, false);
    }

    protected FolderObject updateFolder(EnumAPI api, FolderObject folder, final boolean cascadePermissions) throws Exception {
        return this.updateFolder(api, folder, new RequestCustomizer<UpdateRequest>(){

            @Override
            public void customize(UpdateRequest request) {
                request.setCascadePermissions(cascadePermissions);
            }
        });
    }

    protected FolderObject updateFolder(EnumAPI api, FolderObject folder, RequestCustomizer<UpdateRequest> customizer) throws Exception {
        UpdateRequest request = new UpdateRequest((API)api, folder);
        request.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        if (customizer != null) {
            customizer.customize(request);
        }
        InsertResponse insertResponse = this.client.execute(request);
        insertResponse.fillObject((DataObject)folder);
        this.remember(folder);
        FolderObject updatedFolder = this.getFolder(api, folder.getObjectID());
        ShareTest.assertNotNull((Object)updatedFolder);
        ShareTest.assertEquals((String)"Folder name wrong", (String)folder.getFolderName(), (String)updatedFolder.getFolderName());
        return updatedFolder;
    }

    protected File updateFile(File file, File.Field[] modifiedColumns) throws Exception {
        return this.updateFile(file, modifiedColumns, null);
    }

    protected File updateFile(File file, File.Field[] modifiedColumns, RequestCustomizer<UpdateInfostoreRequest> customizer) throws Exception {
        UpdateInfostoreRequest updateInfostoreRequest = new UpdateInfostoreRequest(file, modifiedColumns, file.getLastModified());
        updateInfostoreRequest.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        updateInfostoreRequest.setFailOnError(true);
        if (customizer != null) {
            customizer.customize(updateInfostoreRequest);
        }
        UpdateInfostoreResponse updateInfostoreResponse = this.getClient().execute(updateInfostoreRequest);
        ShareTest.assertFalse((boolean)updateInfostoreResponse.hasError());
        GetInfostoreRequest getInfostoreRequest = new GetInfostoreRequest(updateInfostoreResponse.getID());
        getInfostoreRequest.setFailOnError(true);
        GetInfostoreResponse getInfostoreResponse = this.getClient().execute(getInfostoreRequest);
        return getInfostoreResponse.getDocumentMetadata();
    }

    protected File getFile(String id) throws Exception {
        GetInfostoreRequest getInfostoreRequest = new GetInfostoreRequest(id);
        getInfostoreRequest.setFailOnError(true);
        GetInfostoreResponse getInfostoreResponse = this.getClient().execute(getInfostoreRequest);
        return getInfostoreResponse.getDocumentMetadata();
    }

    protected FolderObject getFolder(EnumAPI api, int objectID) throws Exception {
        return ShareTest.getFolder(api, objectID, this.client);
    }

    protected static FolderObject getFolder(EnumAPI api, int objectID, AJAXClient client) throws Exception {
        GetResponse getResponse = client.execute(new GetRequest((API)api, objectID));
        FolderObject folder = getResponse.getFolder();
        folder.setLastModified(getResponse.getTimestamp());
        return folder;
    }

    protected FolderObject insertFolder(EnumAPI api, FolderObject folder) throws Exception {
        FolderObject createdFolder = ShareTest.insertFolder(this.client, api, folder);
        ShareTest.assertNotNull((Object)createdFolder);
        this.remember(createdFolder);
        ShareTest.assertEquals((String)"Folder name wrong", (String)folder.getFolderName(), (String)createdFolder.getFolderName());
        return createdFolder;
    }

    protected static FolderObject insertFolder(AJAXClient client, EnumAPI api, FolderObject folder) throws Exception {
        InsertRequest insertRequest = new InsertRequest((API)api, folder, client.getValues().getTimeZone());
        insertRequest.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        InsertResponse insertResponse = client.execute(insertRequest);
        insertResponse.fillObject((DataObject)folder);
        return ShareTest.getFolder(api, folder.getObjectID(), client);
    }

    protected void remember(FolderObject folder) {
        if (null != folder) {
            this.foldersToDelete.put(folder.getObjectID(), folder);
        }
    }

    protected void remember(File file) {
        if (null != file) {
            this.filesToDelete.put(file.getId(), file);
        }
    }

    protected List<FolderShare> getFolderShares(EnumAPI api, int module) throws Exception {
        return ShareTest.getFolderShares(this.client, api, module);
    }

    protected static List<FolderShare> getFolderShares(AJAXClient client, EnumAPI api, int module) throws Exception {
        return client.execute(new FolderSharesRequest((API)api, Module.getModuleString((int)module, (int)-1))).getShares(client.getValues().getTimeZone());
    }

    protected List<FileShare> getFileShares() throws Exception {
        return ShareTest.getFileShares(this.client);
    }

    protected static List<FileShare> getFileShares(AJAXClient client) throws Exception {
        return client.execute(new FileSharesRequest()).getShares(client.getValues().getTimeZone());
    }

    protected String discoverShareURL(ExtendedPermissionEntity guestEntity) throws Exception {
        return this.discoverShareURL(this.client, guestEntity);
    }

    protected String discoverShareURL(AJAXClient client, ExtendedPermissionEntity guestEntity) throws Exception {
        switch (guestEntity.getType()) {
            case ANONYMOUS: {
                return guestEntity.getShareURL();
            }
            case GUEST: {
                ShareTest.assertNotNull((String)"No contact in guest entity", (Object)guestEntity.getContact());
                String email = guestEntity.getContact().getEmail1();
                ShareTest.assertNotNull((String)"No mail address in guest entity", (Object)email);
                return this.discoverInvitationLink(client, email);
            }
        }
        ShareTest.fail((String)("unexpected recipient type: " + guestEntity.getType()));
        return null;
    }

    protected GetMailsResponse.Message discoverInvitationMessage(AJAXClient client, String emailAddress) throws Exception {
        List<GetMailsResponse.Message> messages = client.execute(new GetMailsRequest()).getMessages();
        for (GetMailsResponse.Message message : messages) {
            Map<String, String> headers = message.getHeaders();
            String toHeader = headers.get("To");
            if (Strings.isEmpty((String)toHeader)) continue;
            InternetAddress[] addresses = null;
            try {
                addresses = InternetAddress.parseHeader((String)toHeader, (boolean)false);
            }
            catch (AddressException e) {
                ShareTest.fail((String)e.getMessage());
            }
            if (null == addresses || 0 >= addresses.length) continue;
            for (InternetAddress address : addresses) {
                if (!emailAddress.equals(address.getAddress())) continue;
                return message;
            }
        }
        return null;
    }

    protected String discoverInvitationLink(AJAXClient client, String emailAddress) throws Exception {
        GetMailsResponse.Message message = this.discoverInvitationMessage(client, emailAddress);
        if (null != message) {
            return message.getHeaders().get("X-Open-Xchange-Share-URL");
        }
        return null;
    }

    protected ExtendedPermissionEntity discoverGuestEntity(EnumAPI api, int module, int folderID, int guest) throws Exception {
        return ShareTest.discoverGuestEntity(this.client, api, module, folderID, guest);
    }

    protected static ExtendedPermissionEntity discoverGuestEntity(AJAXClient client, EnumAPI api, int module, int folderID, int guest) throws Exception {
        List<FolderShare> shares = ShareTest.getFolderShares(client, api, module);
        for (FolderShare share : shares) {
            if (share.getObjectID() != folderID) continue;
            return ShareTest.discoverGuestEntity(share.getExtendedPermissions(), guest);
        }
        return null;
    }

    protected ExtendedPermissionEntity discoverGuestEntity(String folder, String item, int guest) throws Exception {
        return ShareTest.discoverGuestEntity(this.client, folder, item, guest);
    }

    protected static ExtendedPermissionEntity discoverGuestEntity(AJAXClient client, String folder, String item, int guest) throws Exception {
        List<FileShare> shares = ShareTest.getFileShares(client);
        for (FileShare share : shares) {
            if (!share.getId().equals(item)) continue;
            return ShareTest.discoverGuestEntity(share.getExtendedPermissions(), guest);
        }
        return null;
    }

    protected static ExtendedPermissionEntity discoverGuestEntity(List<ExtendedPermissionEntity> entities, int guest) throws OXException, IOException, JSONException {
        if (null != entities) {
            for (ExtendedPermissionEntity entity : entities) {
                if (entity.getEntity() != guest) continue;
                return entity;
            }
        }
        return null;
    }

    protected static Date futureTimestamp() {
        return new Date(System.currentTimeMillis() + 1000000L);
    }

    protected static void deleteFoldersSilently(AJAXClient client, Map<Integer, FolderObject> foldersToDelete) throws Exception {
        ShareTest.deleteFoldersSilently(client, foldersToDelete.keySet());
    }

    protected static void deleteFoldersSilently(AJAXClient client, Collection<Integer> foldersIDs) throws Exception {
        if (null != client && null != foldersIDs && 0 < foldersIDs.size()) {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OX_NEW, Autoboxing.I2i(foldersIDs), ShareTest.futureTimestamp());
            deleteRequest.setHardDelete(Boolean.TRUE);
            client.execute(deleteRequest);
        }
    }

    protected static void deleteFilesSilently(AJAXClient client, Collection<File> files) throws Exception {
        if (null != client && null != files && 0 < files.size()) {
            ArrayList<String> folderIDs = new ArrayList<String>();
            ArrayList<String> fileIDs = new ArrayList<String>();
            for (File file : files) {
                folderIDs.add(file.getFolderId());
                fileIDs.add(file.getId());
            }
            DeleteInfostoreRequest deleteInfostoreRequest = new DeleteInfostoreRequest(fileIDs, folderIDs, ShareTest.futureTimestamp());
            deleteInfostoreRequest.setHardDelete(Boolean.TRUE);
            client.execute(deleteInfostoreRequest);
        }
    }

    protected GuestClient resolveShare(ExtendedPermissionEntity guestPermission, ShareRecipient recipient) throws Exception {
        return new GuestClient(this.discoverShareURL(guestPermission), recipient);
    }

    protected GuestClient resolveShare(String shareURL, ShareRecipient recipient) throws Exception {
        return new GuestClient(shareURL, recipient);
    }

    protected GuestClient resolveShare(ExtendedPermissionEntity guestPermission, String username, String password) throws Exception {
        return this.resolveShare(guestPermission.getShareURL(), username, password);
    }

    protected GuestClient resolveShare(String url, String username, String password) throws Exception {
        return new GuestClient(url, username, password);
    }

    protected GuestClient resolveShare(String url) throws Exception {
        return new GuestClient(new GuestClient.ClientConfig(url));
    }

    protected boolean awaitGuestCleanup(int guestID, long timeout) throws Exception {
        long until = System.currentTimeMillis() + timeout;
        do {
            com.openexchange.ajax.user.actions.GetResponse response;
            if ((response = this.getClient().execute(new com.openexchange.ajax.user.actions.GetRequest(guestID, TimeZones.UTC, false))).hasError() && null != response.getException()) {
                OXException e = response.getException();
                if ("USR-0010".equals(e.getErrorCode())) {
                    return true;
                }
                if (!"CON-0125".equals(e.getErrorCode())) {
                    throw e;
                }
            }
            Thread.sleep(500L);
        } while (System.currentTimeMillis() < until);
        return false;
    }

    protected void checkGuestUserDeleted(int guestID) throws Exception {
        ShareTest.assertTrue((String)("Guest user " + guestID + " not deleted after " + 30000 + "ms"), (boolean)this.awaitGuestCleanup(guestID, 30000L));
    }

    protected static void checkPermissions(OCLPermission expected, OCLPermission actual) {
        ShareTest.assertEquals((String)"Permission wrong", (int)expected.getDeletePermission(), (int)actual.getDeletePermission());
        ShareTest.assertEquals((String)"Permission wrong", (int)expected.getFolderPermission(), (int)actual.getFolderPermission());
        ShareTest.assertEquals((String)"Permission wrong", (int)expected.getReadPermission(), (int)actual.getReadPermission());
        ShareTest.assertEquals((String)"Permission wrong", (int)expected.getWritePermission(), (int)actual.getWritePermission());
    }

    protected static void checkPermissions(FileStorageObjectPermission expected, FileStorageObjectPermission actual) {
        ShareTest.assertEquals((String)"Permission wrong", (boolean)expected.canDelete(), (boolean)actual.canDelete());
        ShareTest.assertEquals((String)"Permission wrong", (boolean)expected.canWrite(), (boolean)actual.canWrite());
        ShareTest.assertEquals((String)"Permission wrong", (boolean)expected.canRead(), (boolean)actual.canRead());
    }

    protected static void checkGuestPermission(FileStorageObjectPermission expectedPermission, ExtendedPermissionEntity actual) {
        ShareTest.assertNotNull((String)"No guest permission entitiy", (Object)actual);
        ShareTest.checkPermissions(expectedPermission, actual.toObjectPermission());
        if (FileStorageGuestObjectPermission.class.isInstance(expectedPermission)) {
            ShareTest.checkRecipient(((FileStorageGuestObjectPermission)expectedPermission).getRecipient(), actual);
        } else {
            ShareTest.assertEquals((String)"Entity ID wrong", (int)actual.getEntity(), (int)expectedPermission.getEntity());
            ShareTest.assertEquals((String)"Recipient type wrong", (Object)actual.getType(), (Object)(expectedPermission.isGroup() ? RecipientType.GROUP : RecipientType.USER));
        }
    }

    protected static void checkGuestPermission(OCLPermission expectedPermission, ExtendedPermissionEntity actual) {
        ShareTest.assertNotNull((String)("No guest permission entitiy for entity " + expectedPermission.getEntity()), (Object)actual);
        ShareTest.checkPermissions(expectedPermission, actual.toFolderPermission(expectedPermission.getFuid()));
        if (OCLGuestPermission.class.isInstance(expectedPermission)) {
            ShareTest.checkRecipient(((OCLGuestPermission)expectedPermission).getRecipient(), actual);
        } else {
            ShareTest.assertEquals((String)"Entity ID wrong", (int)actual.getEntity(), (int)expectedPermission.getEntity());
            ShareTest.assertEquals((String)"Recipient type wrong", (Object)actual.getType(), (Object)(expectedPermission.isGroupPermission() ? RecipientType.GROUP : RecipientType.USER));
        }
    }

    private static void checkRecipient(ShareRecipient expected, ExtendedPermissionEntity actual) {
        ShareTest.assertEquals((String)"Wrong recipient type", (Object)expected.getType(), (Object)actual.getType());
        if (RecipientType.ANONYMOUS.equals((Object)expected.getType())) {
            AnonymousRecipient anonymousRecipient = (AnonymousRecipient)expected;
            ShareTest.assertEquals((String)"Wrong password", (String)anonymousRecipient.getPassword(), (String)actual.getPassword());
            ShareTest.assertEquals((String)"Expiry date wrong", (Object)anonymousRecipient.getExpiryDate(), (Object)actual.getExpiry());
        } else if (RecipientType.GUEST.equals((Object)expected.getType())) {
            GuestRecipient guestRecipient = (GuestRecipient)expected;
            ShareTest.assertEquals((String)"Wrong display name", (String)guestRecipient.getDisplayName(), (String)actual.getDisplayName());
            ShareTest.assertNotNull((String)"No contact", (Object)actual.getContact());
            ShareTest.assertEquals((String)"Wrong e-mail address", (String)guestRecipient.getEmailAddress(), (String)actual.getContact().getEmail1());
        }
    }

    protected static OCLGuestPermission createNamedGuestPermission(String emailAddress, String displayName, String password) {
        OCLGuestPermission guestPermission = ShareTest.createNamedPermission(emailAddress, displayName, password);
        guestPermission.setAllPermission(2, 4, 0, 0);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createNamedGuestPermission(String emailAddress, String displayName) {
        OCLGuestPermission guestPermission = ShareTest.createNamedPermission(emailAddress, displayName);
        guestPermission.setAllPermission(2, 4, 0, 0);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createNamedAuthorPermission(String emailAddress, String displayName, String password) {
        OCLGuestPermission guestPermission = ShareTest.createNamedPermission(emailAddress, displayName, password);
        guestPermission.setAllPermission(4, 4, 4, 0);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createNamedAuthorPermission(String emailAddress, String displayName) {
        OCLGuestPermission guestPermission = ShareTest.createNamedPermission(emailAddress, displayName);
        guestPermission.setAllPermission(4, 4, 4, 0);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createNamedPermission(String emailAddress, String displayName, String password) {
        OCLGuestPermission guestPermission = new OCLGuestPermission();
        GuestRecipient guestRecipient = new GuestRecipient();
        guestRecipient.setEmailAddress(emailAddress);
        guestRecipient.setDisplayName(displayName);
        guestRecipient.setPassword(password);
        guestPermission.setRecipient((ShareRecipient)guestRecipient);
        guestPermission.setGroupPermission(false);
        guestPermission.setFolderAdmin(false);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createNamedPermission(String emailAddress, String displayName) {
        OCLGuestPermission guestPermission = new OCLGuestPermission();
        GuestRecipient guestRecipient = new GuestRecipient();
        guestRecipient.setEmailAddress(emailAddress);
        guestRecipient.setDisplayName(displayName);
        guestPermission.setRecipient((ShareRecipient)guestRecipient);
        guestPermission.setGroupPermission(false);
        guestPermission.setFolderAdmin(false);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createAnonymousGuestPermission(String password) {
        OCLGuestPermission guestPermission = ShareTest.createAnonymousPermission(password);
        guestPermission.setAllPermission(2, 4, 0, 0);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createAnonymousGuestPermission() {
        return ShareTest.createAnonymousGuestPermission(null);
    }

    protected static OCLGuestPermission createAnonymousPermission(String password) {
        AnonymousRecipient recipient = new AnonymousRecipient();
        recipient.setPassword(password);
        OCLGuestPermission guestPermission = new OCLGuestPermission((ShareRecipient)recipient);
        AnonymousRecipient anonymousRecipient = new AnonymousRecipient();
        anonymousRecipient.setPassword(password);
        guestPermission.setRecipient((ShareRecipient)anonymousRecipient);
        guestPermission.setGroupPermission(false);
        guestPermission.setFolderAdmin(false);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static FileStorageGuestObjectPermission asObjectPermission(OCLPermission guestPermission) {
        DefaultFileStorageGuestObjectPermission objectPermission = new DefaultFileStorageGuestObjectPermission();
        objectPermission.setEntity(guestPermission.getEntity());
        objectPermission.setGroup(guestPermission.isGroupPermission());
        if (guestPermission instanceof OCLGuestPermission) {
            objectPermission.setRecipient(((OCLGuestPermission)guestPermission).getRecipient());
        }
        if (guestPermission.canWriteAllObjects()) {
            objectPermission.setPermissions(2);
        } else if (guestPermission.canReadAllObjects()) {
            objectPermission.setPermissions(1);
        }
        objectPermission.getRecipient().setBits(objectPermission.getPermissions());
        return objectPermission;
    }

    protected int getDefaultFolder(int module) throws Exception {
        return ShareTest.getDefaultFolder(this.client, module);
    }

    protected static int getDefaultFolder(AJAXClient client, int module) throws Exception {
        switch (module) {
            case 3: {
                return client.getValues().getPrivateContactFolder();
            }
            case 2: {
                return client.getValues().getPrivateAppointmentFolder();
            }
            case 8: {
                return client.getValues().getPrivateInfostoreFolder();
            }
            case 1: {
                return client.getValues().getPrivateTaskFolder();
            }
        }
        Assert.fail((String)("No default folder for moduel: " + module));
        return 0;
    }

    protected static String randomUID() {
        return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
    }

    protected static int randomModule() {
        return TESTED_MODULES[random.nextInt(TESTED_MODULES.length)];
    }

    protected static EnumAPI randomFolderAPI() {
        return TESTED_FOLDER_APIS[random.nextInt(TESTED_FOLDER_APIS.length)];
    }

    protected static OCLGuestPermission randomGuestPermission(int module) {
        OCLGuestPermission permission;
        while (!ShareTest.isReadOnly(permission = TESTED_PERMISSIONS[random.nextInt(TESTED_PERMISSIONS.length)]) && ShareTest.isReadOnlySharing(module)) {
        }
        return permission;
    }

    protected static OCLGuestPermission randomGuestPermission(RecipientType type, int module) {
        OCLGuestPermission permission;
        while (!type.equals((Object)(permission = ShareTest.randomGuestPermission(module)).getRecipient().getType())) {
        }
        return permission;
    }

    protected static FileStorageGuestObjectPermission randomGuestObjectPermission() {
        return TESTED_OBJECT_PERMISSIONS[random.nextInt(TESTED_OBJECT_PERMISSIONS.length)];
    }

    protected static FileStorageGuestObjectPermission randomGuestObjectPermission(RecipientType type) {
        FileStorageGuestObjectPermission permission;
        while (!type.equals((Object)(permission = TESTED_OBJECT_PERMISSIONS[random.nextInt(TESTED_OBJECT_PERMISSIONS.length)]).getRecipient().getType())) {
        }
        return permission;
    }

    protected static boolean isReadOnlySharing(int module) {
        return 2 == module || 1 == module || 3 == module;
    }

    protected static boolean isReadOnly(OCLPermission permission) {
        return false == (permission.canWriteOwnObjects() || permission.canCreateObjects() || permission.canDeleteOwnObjects());
    }

    protected static boolean isReadOnly(FileStorageObjectPermission permission) {
        return false == (permission.canDelete() || permission.canWrite());
    }

    public static String getUsername(ShareRecipient recipient) {
        switch (recipient.getType()) {
            case ANONYMOUS: {
                return recipient.getType().toString().toLowerCase();
            }
            case GUEST: {
                return ((GuestRecipient)recipient).getEmailAddress();
            }
        }
        Assert.fail((String)("Unknown recipient: " + recipient.getType()));
        return null;
    }

    public static String getPassword(ShareRecipient recipient) {
        switch (recipient.getType()) {
            case ANONYMOUS: {
                return ((AnonymousRecipient)recipient).getPassword();
            }
            case GUEST: {
                return ((GuestRecipient)recipient).getPassword();
            }
        }
        Assert.fail((String)("Unknown recipient: " + recipient.getType()));
        return null;
    }

    protected static interface RequestCustomizer<R extends AJAXRequest<?>> {
        public void customize(R var1);
    }
}

