/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.actions.UpdatePublicationRequest;
import com.openexchange.ajax.publish.actions.UpdatePublicationResponse;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Autoboxing;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class UpdatePublicationTest
extends AbstractPublicationTest {
    public UpdatePublicationTest(String name) {
        super(name);
    }

    public void testShouldUpdateExistingPublication() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        Contact contact = this.createDefaultContactFolderWithOneContact();
        String folderID = String.valueOf(contact.getParentFolderID());
        String module = "contacts";
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        Publication orignal = this.generatePublication(module, folderID, discovery);
        NewPublicationRequest newReq = new NewPublicationRequest(orignal);
        NewPublicationResponse newResp = this.getClient().execute(newReq);
        UpdatePublicationTest.assertFalse((String)"Should contain no error after creating", (boolean)newResp.hasError());
        orignal.setId(newResp.getId());
        Publication update = this.generatePublication(module, folderID, discovery);
        update.setId(newResp.getId());
        UpdatePublicationRequest updReq = new UpdatePublicationRequest(update);
        UpdatePublicationResponse updResp = this.getClient().execute(updReq);
        UpdatePublicationTest.assertFalse((String)"Should contain no error after updating", (boolean)updResp.hasError());
        UpdatePublicationTest.assertEquals((String)"Should return 1 in case of success", (Object)Autoboxing.I((int)1), (Object)updResp.getData());
    }

    public void testShouldBeAbleToUpdateExistingPublicationsSiteName() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Contact contact = this.createDefaultContactFolderWithOneContact();
        String folderID = String.valueOf(contact.getParentFolderID());
        Publication pub1 = this.generatePublication("contacts", folderID, discovery);
        pub1.getConfiguration().put("siteName", "oldName");
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        this.pubMgr.newAction(pub1);
        UpdatePublicationTest.assertFalse((String)"Should contain no error after creating", (boolean)this.pubMgr.getLastResponse().hasError());
        Publication pub2 = this.pubMgr.getAction(pub1.getId());
        UpdatePublicationTest.assertEquals((String)"Should have set the siteName", (Object)"oldName", pub2.getConfiguration().get("siteName"));
        Publication pub3 = this.generatePublication("contacts", folderID, discovery);
        pub3.setId(pub1.getId());
        pub3.getConfiguration().put("siteName", "newName");
        this.pubMgr.updateAction(pub3);
        UpdatePublicationResponse updResp = (UpdatePublicationResponse)this.pubMgr.getLastResponse();
        UpdatePublicationTest.assertFalse((String)"Should contain no error after updating", (boolean)updResp.hasError());
        UpdatePublicationTest.assertTrue((String)"Should return 1 in case of success", (boolean)updResp.wasSuccessful());
        Publication pub4 = this.pubMgr.getAction(pub3.getId());
        UpdatePublicationTest.assertEquals((String)"Should have updated the siteName", (Object)"newName", pub4.getConfiguration().get("siteName"));
    }
}

