/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.ajax.oauth.provider.protocol.GETRequest;
import com.openexchange.ajax.oauth.provider.protocol.GETResponse;
import com.openexchange.ajax.oauth.provider.protocol.Grant;
import com.openexchange.ajax.oauth.provider.protocol.HttpTools;
import com.openexchange.ajax.oauth.provider.protocol.OAuthParams;
import com.openexchange.ajax.oauth.provider.protocol.POSTRequest;
import com.openexchange.ajax.oauth.provider.protocol.POSTResponse;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.junit.Assert;

public class Protocol {
    public static String login(HttpClient client, OAuthParams params, String login, String password) throws IOException {
        GETRequest getLoginForm = (GETRequest)((GETRequest)((GETRequest)((GETRequest)((GETRequest)new GETRequest().setHostname(params.getHostname())).setClientId(params.getClientId())).setRedirectURI(params.getRedirectURI())).setState(params.getState())).setScope(params.getScope());
        GETResponse loginFormResponse = getLoginForm.execute(client);
        POSTRequest loginRequest = loginFormResponse.preparePOSTRequest().setLogin(login).setPassword(password);
        POSTResponse loginResponse = loginRequest.submit(client);
        loginResponse.assertRedirect();
        URI redirectLocation = loginResponse.getRedirectLocation();
        String sessionId = HttpTools.extractQueryParams(redirectLocation).get("session");
        Assert.assertNotNull((String)"Session ID is missing in response", (Object)sessionId);
        return sessionId;
    }

    public static String authorize(HttpClient client, OAuthParams params, String sessionId) throws IOException {
        GETRequest getAuthForm = (GETRequest)((GETRequest)((GETRequest)((GETRequest)((GETRequest)((GETRequest)new GETRequest().setHostname(params.getHostname())).setClientId(params.getClientId())).setRedirectURI(params.getRedirectURI())).setState(params.getState())).setScope(params.getScope())).setSessionId(sessionId);
        POSTRequest authRequest = getAuthForm.execute(client).preparePOSTRequest();
        POSTResponse authResponse = authRequest.submit(client);
        URI redirectLocation = authResponse.getRedirectLocation();
        Assert.assertTrue((String)("Unexpected redirect location: " + redirectLocation), (boolean)redirectLocation.toString().startsWith(params.getRedirectURI()));
        Map<String, String> redirectParams = HttpTools.extractQueryParams(redirectLocation);
        Assert.assertNull((String)("Response contained an error: " + redirectParams.get("error") + " [" + redirectParams.get("error_description") + "]"), (Object)redirectParams.get("error"));
        Assert.assertEquals((String)"Unexpected state", (Object)params.getState(), (Object)redirectParams.get("state"));
        Assert.assertNotNull((String)"Auth code missing in response", (Object)redirectParams.get("code"));
        return redirectParams.get("code");
    }

    public static Grant redeemAuthCode(HttpClient client, OAuthParams params, String authCode) throws Exception {
        LinkedList<BasicNameValuePair> redeemAuthCodeParams = new LinkedList<BasicNameValuePair>();
        redeemAuthCodeParams.add(new BasicNameValuePair("client_id", params.getClientId()));
        redeemAuthCodeParams.add(new BasicNameValuePair("client_secret", params.getClientSecret()));
        redeemAuthCodeParams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        redeemAuthCodeParams.add(new BasicNameValuePair("redirect_uri", params.getRedirectURI()));
        redeemAuthCodeParams.add(new BasicNameValuePair("code", authCode));
        HttpPost redeemAuthCode = new HttpPost(new URIBuilder().setScheme("https").setHost(params.getHostname()).setPath("/ajax/oauth/provider/accessToken").build());
        redeemAuthCode.setEntity((HttpEntity)new UrlEncodedFormEntity(redeemAuthCodeParams));
        HttpResponse accessTokenResponse = client.execute((HttpUriRequest)redeemAuthCode);
        Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusLine().getStatusCode());
        JSONObject jAccessTokenResponse = JSONObject.parse((Reader)new InputStreamReader(accessTokenResponse.getEntity().getContent(), accessTokenResponse.getEntity().getContentEncoding() == null ? "UTF-8" : accessTokenResponse.getEntity().getContentEncoding().getValue())).toObject();
        Assert.assertTrue((boolean)"bearer".equalsIgnoreCase(jAccessTokenResponse.getString("token_type")));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("access_token"));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("refresh_token"));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("scope"));
        Assert.assertNotNull((Object)jAccessTokenResponse.get("expires_in"));
        Grant grant = new Grant();
        grant.setAccessToken(jAccessTokenResponse.getString("access_token"));
        grant.setRefreshToken(jAccessTokenResponse.getString("refresh_token"));
        grant.setExpiry(new Date(System.currentTimeMillis() + jAccessTokenResponse.getLong("expires_in") * 1000L));
        grant.setScope(jAccessTokenResponse.getString("scope"));
        return grant;
    }

    public static Grant obtainAccess(HttpClient client, OAuthParams params, String login, String password) throws Exception {
        String sessionId = Protocol.login(client, params, login, password);
        String authCode = Protocol.authorize(client, params, sessionId);
        return Protocol.redeemAuthCode(client, params, authCode);
    }
}

