/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CustomizedParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.oauth.provider.OAuthSession;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.exceptions.OAuthInsufficientScopeException;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidRequestException;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidTokenException;
import com.openexchange.oauth.provider.exceptions.OAuthRequestException;
import com.openexchange.oauth.provider.scope.Scope;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;

public class OAuthClient
extends AJAXClient {
    public OAuthClient(String clientId, String clientSecret, String redirectURI, Scope scope) throws Exception {
        this(AJAXClient.User.User1, clientId, clientSecret, redirectURI, scope);
    }

    public OAuthClient(AJAXClient.User user, String clientId, String clientSecret, String redirectURI, Scope scope) throws Exception {
        super(new OAuthSession(user, clientId, clientSecret, redirectURI, scope), false);
    }

    @Override
    public <T extends AbstractAJAXResponse> T execute(AJAXRequest<T> request) throws OXException, IOException, JSONException {
        return super.execute(new OAuthRequest<T>(((OAuthSession)this.getSession()).getAccessToken(), request));
    }

    public void assertAccess() throws Exception {
        int privateContactFolder = this.getValues().getPrivateContactFolder();
        CommonAllResponse allResponse = this.execute(new AllRequest(privateContactFolder, AllRequest.GUI_COLUMNS));
        Assert.assertFalse((boolean)allResponse.hasError());
    }

    private static final class OAuthResponseParser<T extends AbstractAJAXResponse>
    extends CustomizedParser<T> {
        private OAuthRequestException e;
        private boolean tryParseOAuthError;

        protected OAuthResponseParser(AbstractAJAXParser<T> delegate) {
            super(delegate);
        }

        @Override
        protected String checkCustom(HttpResponse resp) throws ParseException, IOException {
            if (this.isPossibleOAuthError(resp)) {
                this.tryParseOAuthError = true;
                String body = EntityUtils.toString((HttpEntity)resp.getEntity());
                if (body == null) {
                    OAuthResponseParser.fail((String)("Response code is not okay: " + resp.getStatusLine().getStatusCode() + " (" + resp.getStatusLine().getReasonPhrase() + ")"));
                }
                return body;
            }
            return null;
        }

        @Override
        public T parse(String body) throws JSONException {
            if (this.tryParseOAuthError) {
                try {
                    String error;
                    JSONObject jsonObject = new JSONObject(body);
                    switch (error = jsonObject.getString("error")) {
                        case "invalid_token": {
                            String description = jsonObject.getString("error_description");
                            OAuthInvalidTokenException.Reason reason = null;
                            for (Map.Entry entry : OAuthInvalidTokenException.DESCRIPTIONS.entrySet()) {
                                if (!description.equals(entry.getValue())) continue;
                                reason = (OAuthInvalidTokenException.Reason)entry.getKey();
                                break;
                            }
                            this.e = new OAuthInvalidTokenException(reason);
                            break;
                        }
                        case "insufficient_scope": {
                            String requiredScope = jsonObject.optString("scope", null);
                            if (requiredScope == null) {
                                this.e = new OAuthInsufficientScopeException();
                                break;
                            }
                            this.e = new OAuthInsufficientScopeException(requiredScope);
                            break;
                        }
                        case "invalid_request": {
                            this.e = new OAuthInvalidRequestException();
                        }
                    }
                }
                catch (JSONException e) {
                    OAuthResponseParser.fail((String)("Error: " + body));
                }
                if (this.e == null) {
                    OAuthResponseParser.fail((String)("Error: " + body));
                } else {
                    if (this.isFailOnError()) {
                        throw new AssertionError("OAuth error", (Throwable)this.e);
                    }
                    Response response = new Response();
                    response.setException((OXException)this.e);
                    return super.createResponse(response);
                }
            }
            return super.parse(body);
        }

        boolean isPossibleOAuthError(HttpResponse resp) {
            HashSet<Integer> codes = new HashSet<Integer>();
            codes.add(400);
            codes.add(403);
            codes.add(401);
            return codes.contains(resp.getStatusLine().getStatusCode());
        }
    }

    private static final class OAuthRequest<T extends AbstractAJAXResponse>
    implements AJAXRequest<T> {
        private final String accessToken;
        private final AJAXRequest<T> delegate;

        public OAuthRequest(String accessToken, AJAXRequest<T> delegate) {
            this.accessToken = accessToken;
            this.delegate = delegate;
        }

        @Override
        public AJAXRequest.Method getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public String getServletPath() {
            String servletPath = this.delegate.getServletPath();
            return "/ajax/oauth/modules/" + servletPath.substring(6);
        }

        @Override
        public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
            return this.delegate.getParameters();
        }

        @Override
        public AbstractAJAXParser<? extends T> getParser() {
            AbstractAJAXParser<T> parser = this.delegate.getParser();
            return new OAuthResponseParser<T>(parser);
        }

        @Override
        public Object getBody() throws IOException, JSONException {
            return this.delegate.getBody();
        }

        @Override
        public Header[] getHeaders() {
            Header[] headers = this.delegate.getHeaders();
            if (headers == null) {
                return new Header[]{new Header.SimpleHeader("Authorization", "Bearer " + this.accessToken)};
            }
            Header[] newHeaders = new Header[headers.length + 1];
            newHeaders[headers.length] = new Header.SimpleHeader("Authorization", "Bearer " + this.accessToken);
            return newHeaders;
        }
    }
}

