/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.fixtures;

import com.openexchange.ajax.kata.IdentitySource;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.ajax.kata.Step;
import com.openexchange.ajax.kata.fixtures.FixtureTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFixtureTransformer<T>
implements FixtureTransformer {
    private final Map<String, IdentitySource<T>> memory = new HashMap<String, IdentitySource<T>>();
    private final List<PendingResolve> pending = new ArrayList<PendingResolve>();

    @Override
    public void resolveAll() {
        for (PendingResolve pendingResolve : new ArrayList<PendingResolve>(this.pending)) {
            this.pending.remove(pendingResolve);
            this.resolve(pendingResolve.fixtureName, pendingResolve.needExisting);
        }
    }

    protected Step assign(String fixtureName, NeedExistingStep<T> needExisting) {
        if (!this.resolve(fixtureName, needExisting)) {
            this.pending.add(new PendingResolve(fixtureName, needExisting));
        }
        return needExisting;
    }

    protected boolean resolve(String fixtureName, NeedExistingStep<T> needExisting) {
        if (this.memory.containsKey(fixtureName = this.idSourceName(fixtureName))) {
            needExisting.setIdentitySource(this.memory.get(fixtureName));
            return true;
        }
        return false;
    }

    protected void remember(String fixtureName, IdentitySource<T> createAppointmentStep) {
        this.memory.put(this.idSourceName(fixtureName), createAppointmentStep);
    }

    protected boolean isVerification(String fixtureName) {
        return this.postfix(fixtureName).contains("verify");
    }

    protected boolean isUpdate(String fixtureName) {
        if (this.isVerification(fixtureName)) {
            return false;
        }
        return this.postfix(fixtureName).contains("update");
    }

    protected boolean isDelete(String fixtureName) {
        return this.postfix(fixtureName).contains("delete");
    }

    protected boolean isCreate(String fixtureName) {
        return !this.isVerification(fixtureName) && !this.isUpdate(fixtureName) && !this.isDelete(fixtureName);
    }

    protected String postfix(String fixtureName) {
        int index = fixtureName.lastIndexOf(95);
        if (index == -1) {
            return fixtureName;
        }
        return fixtureName.substring(index);
    }

    protected String idSourceName(String fixtureName) {
        int index = fixtureName.lastIndexOf(95);
        if (index == -1) {
            return fixtureName;
        }
        return fixtureName.substring(0, index);
    }

    public class PendingResolve {
        public String fixtureName;
        public NeedExistingStep<T> needExisting;

        public PendingResolve(String fixtureName, NeedExistingStep<T> needExisting) {
            this.fixtureName = fixtureName;
            this.needExisting = needExisting;
        }
    }
}

