/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.TestInit;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug40142Test
extends AbstractInfostoreTest {
    public Bug40142Test(String name) {
        super(name);
    }

    public void testCreatingTwoEquallyNamedFiles() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DefaultFile expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        expected.setFileName("name.name.txt.pgp");
        expected.setLastModified(new Date());
        File file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected, file);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        com.openexchange.file.storage.File actual = this.infoMgr.getAction(expected.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)expected.getFileName(), (String)actual.getFileName());
        expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        expected.setFileName("name.name.txt.pgp");
        expected.setLastModified(new Date());
        file = new File(TestInit.getTestProperty("webdavPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected, file);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        actual = this.infoMgr.getAction(expected.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)"name.name (1).txt.pgp", (String)actual.getFileName());
    }

    public void testUpdateFileWithExistingName() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DefaultFile expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        expected.setFileName("name.name.txt.pgp");
        expected.setLastModified(new Date());
        File file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected, file);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        com.openexchange.file.storage.File actual = this.infoMgr.getAction(expected.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)expected.getFileName(), (String)actual.getFileName());
        DefaultFile expected2 = new DefaultFile();
        expected2.setCreated(new Date());
        expected2.setFolderId(String.valueOf(folder.getObjectID()));
        expected2.setFileName("name.name.txt");
        expected2.setLastModified(new Date());
        File file2 = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected2, file2);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        com.openexchange.file.storage.File actual2 = this.infoMgr.getAction(expected2.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)expected2.getFileName(), (String)actual2.getFileName());
        actual2.setFileName("name.name.txt.pgp");
        this.infoMgr.updateAction(actual2, new File.Field[]{File.Field.FILENAME}, new Date());
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        actual2 = this.infoMgr.getAction(actual2.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)"name.name (1).txt.pgp", (String)actual2.getFileName());
    }

    public void testCopyFile() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DefaultFile expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        expected.setFileName("name.name.txt.pgp");
        expected.setLastModified(new Date());
        File file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected, file);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        com.openexchange.file.storage.File actual = this.infoMgr.getAction(expected.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)expected.getFileName(), (String)actual.getFileName());
        String id = this.infoMgr.copyAction(actual.getId(), folder.getObjectID() + "", actual);
        actual = this.infoMgr.getAction(id);
        Bug40142Test.assertEquals((String)"Name should be the same", (String)"name.name (1).txt.pgp", (String)actual.getFileName());
    }

    public void testDeleteFileWithExistingNameInTrash() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.generateInfostoreFolder("InfostoreCreateDeleteTest Folder");
        this.fMgr.insertFolderOnServer(folder);
        DefaultFile expected = new DefaultFile();
        expected.setCreated(new Date());
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        expected.setFileName("name.name.txt.pgp");
        expected.setLastModified(new Date());
        File file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected, file);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        com.openexchange.file.storage.File actual = this.infoMgr.getAction(expected.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)expected.getFileName(), (String)actual.getFileName());
        String oldID = actual.getId();
        this.infoMgr.deleteAction(Collections.singletonList((Object)actual.getId()), Collections.singletonList((Object)actual.getFolderId()), new Date(), false);
        Bug40142Test.assertFalse((String)"Deleting an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        actual = null;
        DefaultFile expected2 = new DefaultFile();
        expected2.setCreated(new Date());
        expected2.setFolderId(String.valueOf(folder.getObjectID()));
        expected2.setFileName("name.name.txt.pgp");
        expected2.setLastModified(new Date());
        File file2 = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.infoMgr.newAction((com.openexchange.file.storage.File)expected2, file2);
        Bug40142Test.assertFalse((String)"Creating an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        actual = this.infoMgr.getAction(expected2.getId());
        Bug40142Test.assertEquals((String)"Name should be the same", (String)expected2.getFileName(), (String)actual.getFileName());
        this.infoMgr.deleteAction(Collections.singletonList((Object)actual.getId()), Collections.singletonList((Object)actual.getFolderId()), new Date(), false);
        Bug40142Test.assertFalse((String)"Deleting an entry should work", (boolean)this.infoMgr.getLastResponse().hasError());
        int result = (Integer)this.infoMgr.getConfigAction("/modules/infostore/folder/trash");
        String id1 = result + "/" + oldID.substring(oldID.indexOf("/") + 1, oldID.length());
        String id2 = result + "/" + actual.getId().substring(actual.getId().indexOf("/") + 1, actual.getId().length());
        actual = this.infoMgr.getAction(id2);
        Bug40142Test.assertEquals((String)"Name should be the same", (String)"name.name (1).txt.pgp", (String)actual.getFileName());
        this.infoMgr.deleteAction(Collections.singletonList((Object)id1), Collections.singletonList((Object)result), new Date(), true);
        this.infoMgr.deleteAction(Collections.singletonList((Object)id2), Collections.singletonList((Object)result), new Date(), true);
    }
}

