/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.infostore.VersionsTest;
import com.openexchange.test.TestInit;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONObject;

public class DetachTest
extends InfostoreAJAXTest {
    public DetachTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        long FAR_FUTURE = Long.MAX_VALUE;
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        DetachTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        DetachTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        DetachTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        DetachTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        DetachTest.assertNoError(res);
    }

    public void testBasic() throws Exception {
        int[] notDetached = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, System.currentTimeMillis(), (String)this.clean.get(0), new int[]{1, 2, 3, 4, 5});
        DetachTest.assertEquals((int)0, (int)notDetached.length);
        this.checkNoVersions();
    }

    public void testRevert() throws Exception {
        Response res = this.revert(this.getWebConversation(), this.getHostName(), this.sessionId, System.currentTimeMillis(), (String)this.clean.get(0));
        DetachTest.assertNoError(res);
        DetachTest.assertNotNull((Object)res.getTimestamp());
        this.checkNoVersions();
    }

    public void checkNoVersions() throws Exception {
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        DetachTest.assertNoError(res);
        JSONObject obj = (JSONObject)res.getData();
        DetachTest.assertEquals((int)0, (int)obj.getInt("version"));
        int[] notDetached = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, System.currentTimeMillis(), (String)this.clean.get(0), new int[]{1, 2, 3});
        HashSet<Integer> versions = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        DetachTest.assertEquals((int)versions.size(), (int)notDetached.length);
        for (int id : notDetached) {
            DetachTest.assertTrue((boolean)versions.remove(id));
        }
        DetachTest.assertTrue((boolean)versions.isEmpty());
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        DetachTest.assertNoError(res);
        obj = (JSONObject)res.getData();
        DetachTest.assertEquals(null, (Object)obj.opt("filename"));
        DetachTest.assertEquals((Object)"", (Object)obj.get("file_mimetype"));
        DetachTest.assertEquals((Object)0, (Object)obj.get("file_size"));
    }

    public void testSpotted() throws Exception {
        int[] notDetached = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, (String)this.clean.get(0), new int[]{1, 3, 5});
        DetachTest.assertEquals((int)0, (int)notDetached.length);
        Response res = this.versions(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), new int[]{705, 710});
        DetachTest.assertNoError(res);
        VersionsTest.assureVersions(new Integer[]{2, 4}, res, 4);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0));
        DetachTest.assertNoError(res);
        JSONObject obj = (JSONObject)res.getData();
        DetachTest.assertEquals((int)4, (int)obj.getInt("version"));
    }

    public void testDetachVersion0() throws Exception {
        int[] notDetached = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, (String)this.clean.get(0), new int[]{0});
        DetachTest.assertEquals((int)1, (int)notDetached.length);
        DetachTest.assertEquals((int)0, (int)notDetached[0]);
    }

    public void testCopyComments() throws Exception {
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("description", "current_description"));
        DetachTest.assertNoError(res);
        int[] notDetached = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, (String)this.clean.get(0), new int[]{5, 4, 3});
        DetachTest.assertEquals((int)0, (int)notDetached.length);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), 0);
        DetachTest.assertNoError(res);
        JSONObject document = (JSONObject)res.getData();
        DetachTest.assertEquals((Object)"current_description", (Object)document.get("description"));
    }

    public void testUniqueFilenames() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        String id = (String)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("filename", "blupp.properties"));
        DetachTest.assertNoError(res);
        String id2 = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("title", "otherFile", "description", "other_desc", "folder_id", Integer.valueOf(this.folderId).toString()), upload, "text/plain");
        this.clean.add(id2);
        this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, (String)this.clean.get(0), new int[]{5});
    }
}

