/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Charsets;
import com.openexchange.java.util.UUIDs;
import java.io.ByteArrayInputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug37172Test
extends AbstractManagedContactTest {
    public Bug37172Test(String name) {
        super(name);
    }

    public void testNotLosingPhoneNumbers() throws Exception {
        String uid = UUIDs.getUnformattedStringFromRandom();
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:;Test;;;\r\nUID:" + uid + "\r\n" + "REV:2015-03-09T23:04:44+00:00\r\n" + "FN:Test\r\n" + "PRODID:-//ownCloud//NONSGML Contacts 0.3.0.18//EN\r\n" + "EMAIL;TYPE=WORK:test@abc123.de\r\n" + "TEL;TYPE=CELL:0151 123456789\r\n" + "TEL;TYPE=HOME:0911 9876543\r\n" + "TEL;TYPE=HOME:0160 123456\r\n" + "IMPP;X-SERVICE-TYPE=jabber:xmpp:87654321\r\n" + "TEL;TYPE=WORK:0912 12345678\r\n" + "END:VCARD\r\n";
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream(vCard.getBytes(Charsets.UTF_8)));
        VCardImportResponse importResponse = this.getClient().execute(importRequest);
        JSONArray data = (JSONArray)importResponse.getData();
        Bug37172Test.assertTrue((String)"got no data from import request", (null != data && 0 < data.length() ? 1 : 0) != 0);
        JSONObject jsonObject = data.getJSONObject(0);
        Bug37172Test.assertNotNull((String)"got no data from import request", (Object)jsonObject);
        int objectID = jsonObject.optInt("id");
        Bug37172Test.assertTrue((String)"got no object id from import request", (0 < objectID ? 1 : 0) != 0);
        Contact contact = this.manager.getAction(this.folderID, objectID);
        Bug37172Test.assertEquals((String)"firstname wrong", (String)"Test", (String)contact.getGivenName());
        Bug37172Test.assertEquals((String)"lastname wrong", null, (String)contact.getSurName());
        Bug37172Test.assertEquals((String)"cellular phone wrong", (String)"0151 123456789", (String)contact.getCellularTelephone1());
        Bug37172Test.assertEquals((String)"home phone wrong", (String)"0911 9876543", (String)contact.getTelephoneHome1());
        Bug37172Test.assertEquals((String)"home phone alternative wrong", (String)"0160 123456", (String)contact.getTelephoneHome2());
        Bug37172Test.assertEquals((String)"company phone wrong", (String)"0912 12345678", (String)contact.getTelephoneBusiness1());
        Bug37172Test.assertEquals((String)"xmpp jabber wrong", (String)"xmpp:87654321", (String)contact.getInstantMessenger2());
        Bug37172Test.assertEquals((String)"email wrong", (String)"test@abc123.de", (String)contact.getEmail1());
    }

    public void testNotLosingPhoneNumbersAlt() throws Exception {
        String uid = UUIDs.getUnformattedStringFromRandom();
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:;Test;;;\r\nUID:" + uid + "\r\n" + "REV:2015-03-09T23:04:44+00:00\r\n" + "FN:Test\r\n" + "PRODID:-//ownCloud//NONSGML Contacts 0.3.0.18//EN\r\n" + "EMAIL;TYPE=WORK:test@abc123.de\r\n" + "TEL;TYPE=CELL:0151 123456789\r\n" + "TEL;TYPE=home,voice:0911 9876543\r\n" + "TEL;TYPE=home,voice:0160 123456\r\n" + "IMPP;X-SERVICE-TYPE=jabber:xmpp:87654321\r\n" + "TEL;TYPE=WORK,voice:0912 12345678\r\n" + "END:VCARD\r\n";
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream(vCard.getBytes(Charsets.UTF_8)));
        VCardImportResponse importResponse = this.getClient().execute(importRequest);
        JSONArray data = (JSONArray)importResponse.getData();
        Bug37172Test.assertTrue((String)"got no data from import request", (null != data && 0 < data.length() ? 1 : 0) != 0);
        JSONObject jsonObject = data.getJSONObject(0);
        Bug37172Test.assertNotNull((String)"got no data from import request", (Object)jsonObject);
        int objectID = jsonObject.optInt("id");
        Bug37172Test.assertTrue((String)"got no object id from import request", (0 < objectID ? 1 : 0) != 0);
        Contact contact = this.manager.getAction(this.folderID, objectID);
        Bug37172Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug37172Test.assertEquals((String)"firstname wrong", (String)"Test", (String)contact.getGivenName());
        Bug37172Test.assertEquals((String)"lastname wrong", null, (String)contact.getSurName());
        Bug37172Test.assertEquals((String)"cellular phone wrong", (String)"0151 123456789", (String)contact.getCellularTelephone1());
        Bug37172Test.assertEquals((String)"home phone wrong", (String)"0911 9876543", (String)contact.getTelephoneHome1());
        Bug37172Test.assertEquals((String)"home phone alternative wrong", (String)"0160 123456", (String)contact.getTelephoneHome2());
        Bug37172Test.assertEquals((String)"company phone wrong", (String)"0912 12345678", (String)contact.getTelephoneBusiness1());
        Bug37172Test.assertEquals((String)"xmpp jabber wrong", (String)"xmpp:87654321", (String)contact.getInstantMessenger2());
        Bug37172Test.assertEquals((String)"email wrong", (String)"test@abc123.de", (String)contact.getEmail1());
    }
}

