/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.Parser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VisibleFoldersResponse
extends AbstractAJAXResponse {
    private final int[] columns;
    private final Collection<Object[]> privateFolders;
    private final Collection<Object[]> publicFolders;
    private final Collection<Object[]> sharedFolders;

    public VisibleFoldersResponse(Response response, int[] columns) throws JSONException {
        super(response);
        this.columns = columns;
        if (!response.hasError()) {
            List<List<Object[]>> parsedResponse = this.parseResponse();
            this.privateFolders = parsedResponse.get(0);
            this.publicFolders = parsedResponse.get(1);
            this.sharedFolders = parsedResponse.get(2);
        } else {
            this.privateFolders = null;
            this.publicFolders = null;
            this.sharedFolders = null;
        }
    }

    private List<List<Object[]>> parseResponse() throws JSONException {
        JSONObject object = (JSONObject)this.getResponse().getData();
        ArrayList<List<Object[]>> ret = new ArrayList<List<Object[]>>(3);
        if (object.has("private")) {
            Object[][] privateArray = VisibleFoldersResponse.parseData(object.getJSONArray("private"));
            ret.add(Collections.unmodifiableList(Arrays.asList(privateArray)));
        } else {
            ret.add(Collections.emptyList());
        }
        if (object.has("public")) {
            Object[][] publicArray = VisibleFoldersResponse.parseData(object.getJSONArray("public"));
            ret.add(Collections.unmodifiableList(Arrays.asList(publicArray)));
        } else {
            ret.add(Collections.emptyList());
        }
        if (object.has("shared")) {
            Object[][] sharedArray = VisibleFoldersResponse.parseData(object.getJSONArray("shared"));
            ret.add(Collections.unmodifiableList(Arrays.asList(sharedArray)));
        } else {
            ret.add(Collections.emptyList());
        }
        return ret;
    }

    private static Object[][] parseData(JSONArray array) throws JSONException {
        Object[][] values = new Object[array.length()][];
        for (int i = 0; i < array.length(); ++i) {
            try {
                JSONArray inner = array.getJSONArray(i);
                values[i] = new Object[inner.length()];
                for (int j = 0; j < inner.length(); ++j) {
                    values[i][j] = inner.isNull(j) ? null : inner.get(j);
                }
                continue;
            }
            catch (JSONException e) {
                values[i] = new Integer[]{Autoboxing.I((int)array.getInt(i))};
            }
        }
        return values;
    }

    public Iterator<FolderObject> getPrivateFolders() throws OXException {
        return this.getFoldersFrom(this.privateFolders);
    }

    public Iterator<FolderObject> getPublicFolders() throws OXException {
        return this.getFoldersFrom(this.publicFolders);
    }

    public Iterator<FolderObject> getSharedFolders() throws OXException {
        return this.getFoldersFrom(this.sharedFolders);
    }

    private Iterator<FolderObject> getFoldersFrom(Collection<Object[]> col) throws OXException {
        ArrayList<FolderObject> folders = new ArrayList<FolderObject>();
        for (Object[] rows : col) {
            FolderObject folder = new FolderObject();
            for (int columnPos = 0; columnPos < this.columns.length; ++columnPos) {
                Parser.parse(rows[columnPos], this.columns[columnPos], folder);
            }
            folders.add(folder);
        }
        return folders.iterator();
    }
}

