/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.contacts;

import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.contacts.ContactsFindTest;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.find.Module;
import com.openexchange.find.facet.ComplexDisplayItem;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.util.DisplayItems;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.util.TimeZones;

public class AutocompleteTest
extends ContactsFindTest {
    public AutocompleteTest(String name) {
        super(name);
    }

    public void testAutocompleteCurrentUser() throws Exception {
        String defaultAddress = this.client.getValues().getDefaultAddress();
        Contact ownContact = this.client.execute(new GetRequest(this.client.getValues().getUserId(), TimeZones.UTC)).getContact();
        ComplexDisplayItem displayItem = DisplayItems.convert((Contact)ownContact);
        this.assertFoundFacetInAutocomplete(defaultAddress.substring(0, 3), displayItem.getDisplayName());
    }

    public void testAutocompleteOtherContact() throws Exception {
        Contact contact = this.manager.newAction(this.randomContact());
        ComplexDisplayItem displayItem = DisplayItems.convert((Contact)contact);
        this.assertFoundFacetInAutocomplete(contact.getDisplayName().substring(0, 3), displayItem.getDisplayName());
        this.assertFoundFacetInAutocomplete(contact.getSurName().substring(0, 4), displayItem.getDisplayName());
        this.assertFoundFacetInAutocomplete(contact.getGivenName().substring(0, 5), displayItem.getDisplayName());
        this.assertFoundFacetInAutocomplete(contact.getEmail1().substring(0, 3), displayItem.getDisplayName());
    }

    private FacetValue assertFoundFacetInAutocomplete(String prefix, String expectedEmail1) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.CONTACTS.getIdentifier());
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        FacetValue foundFacetValue = AutocompleteTest.findByDisplayName(autocompleteResponse.getFacets(), expectedEmail1);
        AutocompleteTest.assertNotNull((String)("no facet value found for: " + expectedEmail1), (Object)foundFacetValue);
        return foundFacetValue;
    }
}

