/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.UpdateRequest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import org.json.JSONException;
import org.json.JSONObject;

public class EmptyEmailTest
extends AbstractContactTest {
    public EmptyEmailTest(String name) {
        super(name);
    }

    public int insertContact(Contact contactObj, String email1, String email2, String email3) throws Exception {
        InsertRequest request = new InsertRequest(contactObj);
        JSONObject jsonObject = (JSONObject)request.getBody();
        jsonObject = this.setEmail(jsonObject, email1, email2, email3);
        InsertRequest modifiedRequest = new InsertRequest(jsonObject.toString());
        InsertResponse response = this.client.execute(modifiedRequest);
        response.fillObject((DataObject)contactObj);
        return contactObj.getObjectID();
    }

    public void updateContact(Contact contactObj, int inFolder, String email1, String email2, String email3) throws Exception {
        UpdateRequest request = new UpdateRequest(inFolder, contactObj, true);
        JSONObject jsonObject = (JSONObject)request.getBody();
        jsonObject = this.setEmail(jsonObject, email1, email2, email3);
        EmptyEmailUpdateRequest modifiedRequest = new EmptyEmailUpdateRequest(contactObj, jsonObject);
        this.client.execute(modifiedRequest);
    }

    private JSONObject setEmail(JSONObject jo, String email1, String email2, String email3) throws JSONException {
        jo.put("email1", email1 == null ? JSONObject.NULL : email1);
        jo.put("email2", email2 == null ? JSONObject.NULL : email3);
        jo.put("email3", email3 == null ? JSONObject.NULL : email3);
        return jo;
    }

    public void testNewNull() throws Exception {
        Contact contactObj = this.createContactObject("Schmidt, Hans");
        contactObj.setGivenName("Hans");
        contactObj.setSurName("Schmidt");
        this.insertContact(contactObj, null, null, null);
    }

    public void testNewEmpty() throws Exception {
        Contact contactObj = this.createContactObject("Schmidt, Hans");
        contactObj.setGivenName("Hans");
        contactObj.setSurName("Schmidt");
        this.insertContact(contactObj, "", "", "");
    }

    public void testNewSpacy() throws Exception {
        Contact contactObj = this.createContactObject("Schmidt, Hans");
        contactObj.setGivenName("Hans");
        contactObj.setSurName("Schmidt");
        this.insertContact(contactObj, "   ", "   ", "   ");
    }

    public void testUpdateNull() throws Exception {
        Contact contactObj = this.createContactObject("Schmidt, Hans");
        contactObj.setGivenName("Hans");
        contactObj.setSurName("Schmidt");
        contactObj.setEmail1("email1@open-xchange.com");
        contactObj.setEmail2("email2@open-xchange.com");
        contactObj.setEmail3("email3@open-xchange.com");
        int id = this.insertContact(contactObj);
        Contact loadedContact = this.loadContact(id, this.contactFolderId);
        this.updateContact(loadedContact, this.contactFolderId, null, null, null);
    }

    public void testUpdateEmpty() throws Exception {
        Contact contactObj = this.createContactObject("Schmidt, Hans");
        contactObj.setGivenName("Hans");
        contactObj.setSurName("Schmidt");
        contactObj.setEmail1("email1@open-xchange.com");
        contactObj.setEmail2("email2@open-xchange.com");
        contactObj.setEmail3("email3@open-xchange.com");
        int id = this.insertContact(contactObj);
        Contact loadedContact = this.loadContact(id, this.contactFolderId);
        this.updateContact(loadedContact, this.contactFolderId, "", "", "");
    }

    public void testUpdateSpacy() throws Exception {
        Contact contactObj = this.createContactObject("Schmidt, Hans");
        contactObj.setGivenName("Hans");
        contactObj.setSurName("Schmidt");
        contactObj.setEmail1("email1@open-xchange.com");
        contactObj.setEmail2("email2@open-xchange.com");
        contactObj.setEmail3("email3@open-xchange.com");
        int id = this.insertContact(contactObj);
        Contact loadedContact = this.loadContact(id, this.contactFolderId);
        this.updateContact(loadedContact, this.contactFolderId, "   ", "   ", "   ");
    }

    private class EmptyEmailUpdateRequest
    extends UpdateRequest {
        private JSONObject modifiedBody;

        public EmptyEmailUpdateRequest(Contact contactObj) {
            super(contactObj);
        }

        public EmptyEmailUpdateRequest(Contact co, JSONObject jo) {
            super(co);
            this.modifiedBody = jo;
        }

        @Override
        public Object getBody() throws JSONException {
            return this.modifiedBody;
        }
    }
}

