/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.parser.ParticipantParser;
import com.openexchange.calendar.storage.ParticipantStorage;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfirmationsSeriesTest
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 20, 226};
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private Appointment appointment;
    private ExternalUserParticipant participant;

    public ConfirmationsSeriesTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setTitle("Test series appointment for testing confirmations");
        Calendar calendar = TimeTools.createCalendar(this.tz);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setParentFolderID(this.folderId);
        this.appointment.setIgnoreConflicts(true);
        this.participant = new ExternalUserParticipant("external1@example.com");
        this.participant.setDisplayName("External user");
        this.appointment.addParticipant((Participant)this.participant);
        this.participant = new ExternalUserParticipant("external2@example.com");
        this.participant.setDisplayName("External user 2");
        this.appointment.addParticipant((Participant)this.participant);
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.client.execute(new InsertRequest(this.appointment, this.tz)).fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testChangeException() throws Throwable {
        GetResponse response1 = this.client.execute(new GetRequest(this.appointment.getParentFolderID(), this.appointment.getObjectID(), 3));
        Appointment occurrence3 = response1.getAppointment(this.tz);
        Appointment changeException = new Appointment();
        changeException.setObjectID(this.appointment.getObjectID());
        changeException.setParentFolderID(this.appointment.getParentFolderID());
        changeException.setLastModified(this.appointment.getLastModified());
        changeException.setRecurrencePosition(occurrence3.getRecurrencePosition());
        changeException.setTitle("Change exception appointment for testing confirmations");
        changeException.setIgnoreConflicts(true);
        UpdateResponse response2 = this.client.execute(new UpdateRequest(changeException, this.tz));
        this.appointment.setLastModified(response2.getTimestamp());
        GetResponse response3 = this.client.execute(new GetRequest(this.appointment));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), response3.getAppointment(this.tz).getConfirmations());
        CommonAllResponse response4 = this.client.execute(new AllRequest(this.folderId, COLUMNS, occurrence3.getStartDate(), occurrence3.getEndDate(), this.tz));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), this.findConfirmations(response4, response2.getId()));
        CommonListResponse response5 = this.client.execute(new ListRequest(ListIDs.l(new int[][]{{this.folderId, response2.getId()}}), COLUMNS));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), this.findConfirmations(response5, response2.getId()));
        SearchResponse response6 = this.client.execute(new SearchRequest("*", this.folderId, COLUMNS));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), this.findConfirmations(response6, response2.getId()));
    }

    private JSONArray findConfirmations(AbstractColumnsResponse response, int id) {
        int objectIdPos = response.getColumnPos(1);
        int confirmationsPos = response.getColumnPos(226);
        JSONArray jsonConfirmations = null;
        for (Object[] tmp : response) {
            if (id != (Integer)tmp[objectIdPos]) continue;
            jsonConfirmations = (JSONArray)tmp[confirmationsPos];
        }
        return jsonConfirmations;
    }

    private void checkConfirmations(ExternalUserParticipant[] expected, JSONArray jsonConfirmations) throws JSONException {
        ConfirmationsSeriesTest.assertNotNull((String)"Response does not contain confirmations.", (Object)jsonConfirmations);
        ParticipantParser parser = new ParticipantParser();
        ArrayList<ConfirmableParticipant> confirmations = new ArrayList<ConfirmableParticipant>();
        int length = jsonConfirmations.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonConfirmation = jsonConfirmations.getJSONObject(i);
            confirmations.add(parser.parseConfirmation(true, jsonConfirmation));
        }
        this.checkConfirmations(expected, confirmations.toArray(new ConfirmableParticipant[confirmations.size()]));
    }

    private void checkConfirmations(ExternalUserParticipant[] expected, ConfirmableParticipant[] actual) {
        ConfirmationsSeriesTest.assertNotNull((String)"Response does not contain any confirmations.", (Object)actual);
        ConfirmationsSeriesTest.assertEquals((String)"Number of external participant confirmations does not match.", (int)expected.length, (int)actual.length);
        Arrays.sort(expected);
        Arrays.sort(actual);
        for (int i = 0; i < expected.length; ++i) {
            ConfirmationsSeriesTest.assertEquals((String)"Mailaddress of external participant does not match.", (String)expected[i].getEmailAddress(), (String)actual[i].getEmailAddress());
            ConfirmationsSeriesTest.assertEquals((String)"Display name of external participant does not match.", (String)expected[i].getDisplayName(), (String)actual[i].getDisplayName());
            ConfirmationsSeriesTest.assertEquals((String)"Confirm status does not match.", (Object)expected[i].getStatus(), (Object)actual[i].getStatus());
            ConfirmationsSeriesTest.assertEquals((String)"Confirm message does not match.", (String)expected[i].getMessage(), (String)actual[i].getMessage());
        }
    }
}

