/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.PermissionTools;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug16194Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private FolderObject publicFolder;
    private AJAXClient client2;
    private Appointment appointment;
    private TimeZone timeZone;
    private TimeZone timeZone2;
    private int userId;
    private int userId2;

    public Bug16194Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userId = this.client.getValues().getUserId();
        this.timeZone = this.client.getValues().getTimeZone();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.userId2 = this.client2.getValues().getUserId();
        this.timeZone2 = this.client2.getValues().getTimeZone();
        this.publicFolder = this.createPublicFolder();
        this.appointment = new Appointment();
        this.appointment.setTitle("Appointment for bug 16194");
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParentFolderID(this.publicFolder.getObjectID());
        Calendar calendar = TimeTools.createCalendar(this.timeZone);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.userId));
        InsertRequest request = new InsertRequest(this.appointment, this.timeZone);
        AppointmentInsertResponse response = this.client.execute(request);
        response.fillAppointment(this.appointment);
    }

    private FolderObject createPublicFolder() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = new FolderObject();
        folder.setModule(2);
        folder.setParentFolderID(2);
        folder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.client.getValues().getUserId()), "arawada/a", Autoboxing.I((int)this.userId2), "arawada/a"));
        folder.setFolderName("testFolder4Bug16194");
        com.openexchange.ajax.folder.actions.InsertRequest iReq = new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_NEW, folder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)folder);
        folder.setLastModified(new Date());
        return folder;
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.publicFolder));
        super.tearDown();
    }

    public void testMoveFromPublic2Private() throws Throwable {
        Appointment moveMe = new Appointment();
        moveMe.setObjectID(this.appointment.getObjectID());
        moveMe.setLastModified(this.appointment.getLastModified());
        int destFolder = this.client2.getValues().getPrivateAppointmentFolder();
        moveMe.setParentFolderID(destFolder);
        moveMe.setIgnoreConflicts(true);
        UpdateRequest uReq = new UpdateRequest(this.publicFolder.getObjectID(), moveMe, this.timeZone2, true);
        UpdateResponse uResp = this.client2.execute(uReq);
        this.appointment.setLastModified(uResp.getTimestamp());
        this.appointment.setParentFolderID(destFolder);
        GetRequest request = new GetRequest(destFolder, this.appointment.getObjectID());
        GetResponse response = this.client2.execute(request);
        this.appointment.setLastModified(response.getTimestamp());
        Appointment testAppointment = response.getAppointment(this.timeZone2);
        ParticipantTools.assertParticipants(testAppointment.getParticipants(), this.userId, this.userId2);
    }
}

