/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class Bug10154Test
extends AbstractAJAXSession {
    public Bug10154Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParticipantsLost() throws Throwable {
        AJAXClient clientA = this.getClient();
        int userIdA = clientA.getValues().getUserId();
        AJAXClient clientB = new AJAXClient(AJAXClient.User.User2);
        FolderObject folder = Create.folder(1, "Folder to test bug 10154", 2, 1, Create.ocl(userIdA, false, true, 128, 128, 128, 128), Create.ocl(clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = clientA.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, folder));
        response.fillObject((DataObject)folder);
        try {
            TimeZone tzA = clientA.getValues().getTimeZone();
            Appointment appointment = new Appointment();
            List<Participant> onInsert = ParticipantTools.createParticipants(userIdA, clientB.getValues().getUserId());
            Participant[] expected = onInsert.toArray(new Participant[onInsert.size()]);
            appointment.setTitle("Test for bug 10154");
            appointment.setParentFolderID(folder.getObjectID());
            appointment.setStartDate(new Date(TimeTools.getHour(0, tzA)));
            appointment.setEndDate(new Date(TimeTools.getHour(1, tzA)));
            appointment.setParticipants(onInsert);
            appointment.setIgnoreConflicts(true);
            InsertRequest request = new InsertRequest(appointment, tzA);
            CommonInsertResponse response2 = clientA.execute(request);
            appointment.setLastModified(response2.getTimestamp());
            appointment.setObjectID(response2.getId());
            TimeZone tzB = clientB.getValues().getTimeZone();
            Appointment change = new Appointment();
            change.setObjectID(appointment.getObjectID());
            change.setParentFolderID(folder.getObjectID());
            change.setLastModified(appointment.getLastModified());
            change.setStartDate(new Date(TimeTools.getHour(1, tzB)));
            change.setEndDate(new Date(TimeTools.getHour(2, tzB)));
            change.setIgnoreConflicts(true);
            UpdateRequest request2 = new UpdateRequest(change, tzB);
            UpdateResponse response3 = clientB.execute(request2);
            appointment.setLastModified(response3.getTimestamp());
            GetRequest request3 = new GetRequest(folder.getObjectID(), appointment.getObjectID());
            GetResponse response4 = clientA.execute(request3);
            Appointment reload = response4.getAppointment(tzA);
            Participant[] participants = reload.getParticipants();
            Bug10154Test.assertEquals((String)"Participants should not be changed.", (int)expected.length, (int)participants.length);
            Comparator<Participant> comparator = new Comparator<Participant>(){

                @Override
                public int compare(Participant o1, Participant o2) {
                    return o1.getIdentifier() - o2.getIdentifier();
                }
            };
            Arrays.sort(expected, comparator);
            Arrays.sort(participants, comparator);
            for (int i = 0; i < expected.length; ++i) {
                Bug10154Test.assertEquals((String)"Participants should not be changed.", (int)expected[i].getIdentifier(), (int)participants[i].getIdentifier());
            }
        }
        finally {
            clientA.execute(new DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
        }
    }
}

