/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.AbstractAppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import com.openexchange.test.TestManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Before;

public class MoveTestNew
extends AbstractAppointmentTest {
    private AJAXClient.User userA;
    private AJAXClient.User userB;
    private AJAXClient.User userC;
    private AJAXClient clientA;
    private AJAXClient clientB;
    private AJAXClient clientC;
    private UserValues valuesA;
    private UserValues valuesB;
    private UserValues valuesC;
    private CalendarTestManager ctmA;
    private CalendarTestManager ctmB;
    private CalendarTestManager ctmC;
    private FolderTestManager ftmA;
    private FolderTestManager ftmB;
    private FolderTestManager ftmC;
    private FolderObject folderA;
    private FolderObject folderA1;
    private FolderObject folderB;
    private FolderObject folderB1;
    private FolderObject folderB2;
    private FolderObject folderC;
    private FolderObject folderC1;
    private Set<TestManager> tm = new HashSet<TestManager>();
    private int idA;
    private int idB;
    private int idC;

    public MoveTestNew(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.userA = AJAXClient.User.User1;
        this.userB = AJAXClient.User.User2;
        this.userC = AJAXClient.User.User3;
        this.clientA = this.client;
        this.clientB = new AJAXClient(this.userB);
        this.clientC = new AJAXClient(this.userC);
        this.valuesA = this.clientA.getValues();
        this.valuesB = this.clientB.getValues();
        this.valuesC = this.clientC.getValues();
        this.idA = this.valuesA.getUserId();
        this.idB = this.valuesB.getUserId();
        this.idC = this.valuesC.getUserId();
        this.ctmA = new CalendarTestManager(this.clientA);
        this.ctmB = new CalendarTestManager(this.clientB);
        this.ctmC = new CalendarTestManager(this.clientC);
        this.tm.add(this.ctmA);
        this.tm.add(this.ctmB);
        this.tm.add(this.ctmC);
        this.ftmA = new FolderTestManager(this.clientA);
        this.ftmB = new FolderTestManager(this.clientB);
        this.ftmC = new FolderTestManager(this.clientC);
        this.tm.add(this.ftmA);
        this.tm.add(this.ftmB);
        this.tm.add(this.ftmC);
        for (TestManager manager : this.tm) {
            manager.setFailOnError(true);
        }
        this.folderA = this.ftmA.getFolderFromServer(this.valuesA.getPrivateAppointmentFolder());
        this.folderA1 = this.createPrivateFolder("SubfolderA1" + System.currentTimeMillis(), this.ftmA, this.clientA);
        this.ftmA.insertFolderOnServer(this.folderA1);
        this.folderB = this.ftmB.getFolderFromServer(this.valuesB.getPrivateAppointmentFolder());
        this.addAuthorPermissions(this.folderB, this.idA, this.ftmB);
        this.folderB1 = this.createPrivateFolder("SubfolderB1" + System.currentTimeMillis(), this.ftmB, this.clientB, this.clientA);
        this.ftmB.insertFolderOnServer(this.folderB1);
        this.folderB2 = this.createPrivateFolder("SubfolderB2" + System.currentTimeMillis(), this.ftmB, this.clientB, this.clientA);
        this.ftmB.insertFolderOnServer(this.folderB2);
        this.folderC = this.ftmC.getFolderFromServer(this.valuesC.getPrivateAppointmentFolder());
        this.addAuthorPermissions(this.folderC, this.idA, this.ftmC);
        this.folderC1 = this.createPrivateFolder("SubfolderC1" + System.currentTimeMillis(), this.ftmC, this.clientC, this.clientA);
        this.ftmC.insertFolderOnServer(this.folderC1);
    }

    private void addAuthorPermissions(FolderObject folder, int userId, FolderTestManager actor) {
        OCLPermission authorPermissions = this.getAuthorPermissions(userId, folder.getObjectID());
        ArrayList<OCLPermission> newPermissions = new ArrayList<OCLPermission>();
        for (OCLPermission ocl : folder.getPermissions()) {
            if (ocl.getEntity() == userId) continue;
            newPermissions.add(ocl);
        }
        newPermissions.add(authorPermissions);
        folder.removePermissions();
        for (OCLPermission ocl : newPermissions) {
            folder.addPermission(ocl);
        }
        folder.setLastModified(new Date(Long.MAX_VALUE));
        actor.updateFolderOnServer(folder);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        for (TestManager manager : this.tm) {
            manager.cleanUp();
        }
    }

    public void testOwnPrivateToSubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOwnPrivateToSubfolder", this.folderA, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idA, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderA, this.folderA1, this.ctmA);
        loaded = this.get(app, this.folderA1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idA, (int)loaded.getParticipants()[0].getIdentifier());
    }

    public void testOwnPrivateToSubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOwnPrivateToSubfolderWithParticipants", this.folderA, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderA, this.folderA1, this.ctmA);
        loaded = this.get(app, this.folderA1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOwnPrivateToOtherPrivate() throws Exception {
        Appointment app = this.generateAppointment("testOwnPrivateToOtherPrivate", this.folderA, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idA, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderA, this.folderB, this.ctmA);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
    }

    public void testOwnPrivateToOtherPrivateWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOwnPrivateToOtherPrivateWithParticipants", this.folderA, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderA, this.folderB, this.ctmA);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOwnPrivateToOtherSubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOwnPrivateToOtherSubfolder", this.folderA, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idA, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderA, this.folderB1, this.ctmA);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
    }

    public void testOwnPrivateToOtherSubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOwnPrivateToOtherSubfolderWithParticipants", this.folderA, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderA, this.folderB1, this.ctmA);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherPrivateToOwnPrivate() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOwnPrivate", this.folderB, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB, this.folderA, this.ctmA);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void testOtherPrivateToOwnPrivateWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOwnPrivateWithParticipants", this.folderB, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB, this.folderA, this.ctmA);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherPrivateToOtherSubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOtherSubfolder", this.folderB, this.idB);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB, this.folderB1, this.ctmA);
        loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
    }

    public void testOtherPrivateToOtherSubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOtherSubfolderWithParticipants", this.folderB, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB, this.folderB1, this.ctmA);
        loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherPrivateToThirdPartyPrivateWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOtherSubfolder", this.folderB, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB, this.folderC, this.ctmA);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToOwnPrivate() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToOwnPrivate", this.folderB1, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB1, this.folderA, this.ctmA);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToOwnSubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToOwnPrivate", this.folderB1, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB1, this.folderA1, this.ctmA);
        loaded = this.get(app, this.folderA1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToOwnPrivateWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOwnPrivateWithParticipants", this.folderB1, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB1, this.folderA, this.ctmA);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToOwnSubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOwnPrivateWithParticipants", this.folderB1, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB1, this.folderA1, this.ctmA);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToOtherSubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToOwnPrivate", this.folderB1, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB1, this.folderB2, this.ctmA);
        loaded = this.get(app, this.folderB2, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB2.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        loaded = this.get(app, this.folderB2, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB2.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
    }

    public void testOtherSubfolderToOtherSubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToOtherSubfolderWithParticipants", this.folderB1, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB1, this.folderB2, this.ctmA);
        loaded = this.get(app, this.folderB2, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB2.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB2, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB2.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void _testOtherPrivateToThirdPartySubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToThirdPartySubfolder", this.folderB, this.idB);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB, this.folderC1, this.ctmA);
        loaded = this.get(app, this.folderC1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToThirdPartySubfolder() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToThirdPartySubfolder", this.folderB1, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB1, this.folderC1, this.ctmA);
        loaded = this.get(app, this.folderC1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC1, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void testOtherPrivateToThirdPartySubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToThirdPartySubfolderWithParticipants", this.folderB, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB, this.folderC1, this.ctmA);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToThirdPartyPrivate() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToThirdPartyPrivate", this.folderB1, new int[0]);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB1, this.folderC, this.ctmA);
        loaded = this.get(app, this.folderC, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void _testOtherPrivateToThirdPartyPrivate() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOtherSubfolder", this.folderB, this.idB);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)1, (int)loaded.getParticipants().length);
        MoveTestNew.assertEquals((String)"Wrong participant.", (int)this.idB, (int)loaded.getParticipants()[0].getIdentifier());
        this.move(app, this.folderB, this.folderC, this.ctmA);
        loaded = this.get(app, this.folderC, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToThirdPartySubfolderWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherPrivateToOtherSubfolder", this.folderB1, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB1, this.folderC1, this.ctmA);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    public void testOtherSubfolderToThirdPartyPrivateWithParticipants() throws Exception {
        Appointment app = this.generateAppointment("testOtherSubfolderToThirdPartyPrivateWithParticipants", this.folderB1, this.idA, this.idB, this.idC);
        this.ctmA.insert(app);
        Appointment loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        this.move(app, this.folderB1, this.folderC, this.ctmA);
        loaded = this.get(app, this.folderC, this.ctmC);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderC.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderA, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderA.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmB);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
        loaded = this.get(app, this.folderB1, this.ctmA);
        MoveTestNew.assertEquals((String)"Wrong folder id.", (int)this.folderB1.getObjectID(), (int)loaded.getParentFolderID());
        MoveTestNew.assertEquals((String)"Wrong amount of participants.", (int)3, (int)loaded.getParticipants().length);
    }

    private Appointment get(Appointment app, FolderObject inFolder, CalendarTestManager actor) throws Exception {
        return actor.get(inFolder.getObjectID(), app.getObjectID(), true);
    }

    private void move(Appointment app, FolderObject from, FolderObject to, CalendarTestManager ctm) {
        app.setParentFolderID(to.getObjectID());
        ctm.update(from.getObjectID(), app);
    }

    private FolderObject createPrivateFolder(String name, FolderTestManager ftm, AJAXClient ... client) throws Exception {
        FolderObject folder = ftm.generatePrivateFolder(name, 2, client[0].getValues().getPrivateAppointmentFolder(), client[0].getValues().getUserId());
        if (client.length > 1) {
            for (int i = 1; i < client.length; ++i) {
                folder.addPermission(this.getAuthorPermissions(client[i].getValues().getUserId(), folder.getObjectID()));
            }
        }
        return folder;
    }

    private OCLPermission getAuthorPermissions(int userId, int folderId) {
        OCLPermission permissions = new OCLPermission();
        permissions.setEntity(userId);
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(false);
        permissions.setFuid(folderId);
        permissions.setAllPermission(8, 4, 4, 4);
        return permissions;
    }

    private Appointment generateAppointment(String title, FolderObject folder, int ... userIds) {
        Appointment retval = new Appointment();
        retval.setTitle(title);
        retval.setStartDate(TimeTools.D("01.09.2014 08:00"));
        retval.setEndDate(TimeTools.D("01.09.2014 09:00"));
        retval.setParentFolderID(folder.getObjectID());
        retval.setIgnoreConflicts(true);
        if (userIds != null && userIds.length > 0) {
            for (int userId : userIds) {
                retval.addParticipant((Participant)new UserParticipant(userId));
            }
        }
        return retval;
    }
}

