/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.ConfirmRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.server.impl.OCLPermission;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ConfirmOthers
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private AJAXClient clientC;
    private int userIdA;
    private int userIdB;
    private int userIdC;
    private FolderObject folder;
    private Appointment appointment;

    public ConfirmOthers(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.clientC = new AJAXClient(AJAXClient.User.User3);
        this.userIdA = this.clientA.getValues().getUserId();
        this.userIdB = this.clientB.getValues().getUserId();
        this.userIdC = this.clientC.getValues().getUserId();
        this.folder = new FolderObject();
        this.folder.setObjectID(this.clientA.getValues().getPrivateAppointmentFolder());
        this.folder.setLastModified(new Date(Long.MAX_VALUE));
        this.folder.setPermissionsAsArray(new OCLPermission[]{Create.ocl(this.userIdA, false, true, 128, 128, 128, 128), Create.ocl(this.userIdB, false, false, 128, 128, 128, 128)});
        ExternalUserParticipant external = new ExternalUserParticipant("test@example.invalid");
        CommonInsertResponse response = this.clientA.execute(new UpdateRequest((API)EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setTitle("Confirm others test");
        this.appointment.setParentFolderID(this.clientC.getValues().getPrivateAppointmentFolder());
        this.appointment.setStartDate(Calendar.getInstance().getTime());
        this.appointment.setEndDate(new Date(this.appointment.getStartDate().getTime() + 3600000L));
        List<Participant> participants = ParticipantTools.createParticipants(this.userIdA, this.userIdC);
        participants.add((Participant)external);
        this.appointment.setParticipants(participants);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.clientC.getValues().getTimeZone(), false);
        response = this.clientC.execute(request);
        response.fillObject((DataObject)this.appointment);
    }

    @Override
    public void tearDown() throws Exception {
        this.clientC.execute(new DeleteRequest(this.appointment.getObjectID(), this.clientC.getValues().getPrivateAppointmentFolder(), this.appointment.getLastModified()));
        super.tearDown();
    }

    public void testConfirmOthersAllowed() throws Exception {
        this.clientB.execute(new ConfirmRequest(this.folder.getObjectID(), this.appointment.getObjectID(), 1, "yap!", this.userIdA, this.appointment.getLastModified(), true));
        GetResponse getResponse = this.clientA.execute(new GetRequest(this.folder.getObjectID(), this.appointment.getObjectID()));
        Appointment loadedAppointment = getResponse.getAppointment(this.clientA.getValues().getTimeZone());
        this.appointment.setLastModified(getResponse.getTimestamp());
        for (UserParticipant user : loadedAppointment.getUsers()) {
            if (user.getIdentifier() != this.userIdA) continue;
            ConfirmOthers.assertEquals((String)"Wrong confirm status.", (int)1, (int)user.getConfirm());
            ConfirmOthers.assertEquals((String)"Wrong confirm message.", (String)"yap!", (String)user.getConfirmMessage());
        }
    }

    public void testConfirmOthersNotAllowed() throws Exception {
        this.clientC.execute(new ConfirmRequest(this.folder.getObjectID(), this.appointment.getObjectID(), 1, "yap!", this.userIdA, this.appointment.getLastModified(), false));
        GetResponse getResponse = this.clientA.execute(new GetRequest(this.folder.getObjectID(), this.appointment.getObjectID()));
        Appointment loadedAppointment = getResponse.getAppointment(this.clientA.getValues().getTimeZone());
        this.appointment.setLastModified(getResponse.getTimestamp());
        for (UserParticipant user : loadedAppointment.getUsers()) {
            if (user.getIdentifier() != this.userIdA) continue;
            ConfirmOthers.assertEquals((String)"Wrong confirm status.", (int)0, (int)user.getConfirm());
            ConfirmOthers.assertEquals((String)"Wrong confirm message.", null, (String)user.getConfirmMessage());
        }
    }

    public void testConfirmExternal() throws Exception {
        this.clientC.execute(new ConfirmRequest(this.clientC.getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID(), 3, "maybe", "test@example.invalid", this.appointment.getLastModified(), false));
        GetResponse getResponse = this.clientC.execute(new GetRequest(this.clientC.getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID()));
        Appointment loadedAppointment = getResponse.getAppointment(this.clientA.getValues().getTimeZone());
        this.appointment.setLastModified(getResponse.getTimestamp());
        for (ConfirmableParticipant p : loadedAppointment.getConfirmations()) {
            if (!p.getEmailAddress().equals("test@example.invalid")) continue;
            ConfirmOthers.assertEquals((String)"Wrong confirm status.", (int)3, (int)p.getConfirm());
            ConfirmOthers.assertEquals((String)"Wrong confirm message.", (String)"maybe", (String)p.getMessage());
        }
    }
}

