/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.osgi;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginResult;
import com.openexchange.login.NonTransient;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.secret.SecretService;
import com.openexchange.session.Session;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.internal.SubscriptionExecutionServiceImpl;
import com.openexchange.subscribe.osgi.OSGiSubscriptionSourceDiscoveryCollector;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdateActivator
extends HousekeepingActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(AutoUpdateActivator.class);
    public static OSGiSubscriptionSourceDiscoveryCollector COLLECTOR;
    public static SubscriptionExecutionServiceImpl EXECUTOR;

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigViewFactory.class, SecretService.class};
    }

    protected void startBundle() throws Exception {
        this.registerService(LoginHandlerService.class, new SubscriptionLoginHandler());
    }

    private final class SubscriptionLoginHandler
    implements LoginHandlerService,
    NonTransient {
        private SubscriptionLoginHandler() {
        }

        public void handleLogin(LoginResult login) throws OXException {
            try {
                if (COLLECTOR == null || EXECUTOR == null) {
                    return;
                }
                ConfigView view = ((ConfigViewFactory)AutoUpdateActivator.this.getService(ConfigViewFactory.class)).getView(login.getUser().getId(), login.getContext().getContextId());
                if (!((Boolean)view.opt("com.openexchange.subscribe.autorun", Boolean.TYPE, (Object)false)).booleanValue()) {
                    return;
                }
                Context ctx = login.getContext();
                Session session = login.getSession();
                String secret = ((SecretService)AutoUpdateActivator.this.getService(SecretService.class)).getSecret(session);
                long now = System.currentTimeMillis();
                List<SubscriptionSource> sources = COLLECTOR.getSources();
                ArrayList<Subscription> subscriptionsToRefresh = new ArrayList<Subscription>(10);
                for (SubscriptionSource subscriptionSource : sources) {
                    String autorunName = subscriptionSource.getId() + ".autorunInterval";
                    Long interval = (Long)view.opt(autorunName, Long.class, (Object)86400000L);
                    if (interval < 0L) continue;
                    Collection<Subscription> subscriptions = subscriptionSource.getSubscribeService().loadSubscriptions(ctx, login.getUser().getId(), secret);
                    for (Subscription subscription : subscriptions) {
                        long lastUpdate = subscription.getLastUpdate();
                        if (now - lastUpdate <= interval) continue;
                        subscriptionsToRefresh.add(subscription);
                    }
                }
                EXECUTOR.executeSubscriptions(subscriptionsToRefresh, ServerSessionAdapter.valueOf((Session)session), null);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }

        public void handleLogout(LoginResult logout) throws OXException {
        }
    }
}

