/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.generic.FolderUpdaterRegistry;
import com.openexchange.groupware.generic.FolderUpdaterService;
import com.openexchange.groupware.generic.FolderUpdaterServiceV2;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.session.Session;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionErrorMessage;
import com.openexchange.subscribe.SubscriptionExecutionService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionExecutionServiceImpl
implements SubscriptionExecutionService,
FolderUpdaterRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionExecutionServiceImpl.class);
    private static final ConcurrentMap<SubscriptionKey, Object> GUARD_MAP = new ConcurrentHashMap<SubscriptionKey, Object>(1024, 0.9f, 1);
    private static final Object PRESENT = new Object();
    private final SubscriptionSourceDiscoveryService discoverer;
    private final Collection<FolderUpdaterService<?>> folderUpdaters;
    private final ContextService contextService;

    private static boolean tryLock(int subscriptionId, Session session) {
        return null == GUARD_MAP.putIfAbsent(SubscriptionExecutionServiceImpl.key(subscriptionId, session), PRESENT);
    }

    private static void unlock(int subscriptionId, Session session) {
        GUARD_MAP.remove(SubscriptionExecutionServiceImpl.key(subscriptionId, session));
    }

    public SubscriptionExecutionServiceImpl(SubscriptionSourceDiscoveryService discoverer, Collection<FolderUpdaterService<?>> folderUpdaters, ContextService contexts) {
        this.discoverer = discoverer;
        this.folderUpdaters = folderUpdaters;
        this.contextService = contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSubscription(String sourceId, ServerSession session, int subscriptionId) throws OXException {
        if (!SubscriptionExecutionServiceImpl.tryLock(subscriptionId, (Session)session)) {
            return 0;
        }
        try {
            SubscribeService subscribeService = this.discoverer.getSource(sourceId).getSubscribeService();
            Subscription subscription = subscribeService.loadSubscription(session.getContext(), subscriptionId, null);
            subscription.setSession(session);
            boolean knowsSource = this.discoverer.filter(subscription.getUserId(), session.getContextId()).knowsSource(subscribeService.getSubscriptionSource().getId());
            if (!knowsSource) {
                throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
            }
            subscribeService.touch(session.getContext(), subscriptionId);
            SearchIterator<?> data = subscribeService.loadContent(subscription);
            this.storeData(data, subscription, null);
            int n = data.size();
            return n;
        }
        finally {
            SubscriptionExecutionServiceImpl.unlock(subscriptionId, (Session)session);
        }
    }

    protected void storeData(SearchIterator<?> data, Subscription subscription, Collection<OXException> optErrors) throws OXException {
        FolderUpdaterService folderUpdater = this.getFolderUpdater(subscription);
        if (folderUpdater instanceof FolderUpdaterServiceV2) {
            ((FolderUpdaterServiceV2)folderUpdater).save(data, (TargetFolderDefinition)subscription, optErrors);
        } else {
            folderUpdater.save(data, (TargetFolderDefinition)subscription);
        }
    }

    public FolderUpdaterService getFolderUpdater(TargetFolderDefinition target) throws OXException {
        FolderObject folder = this.getFolder(new TargetFolderSession(target), target.getContext().getContextId(), target.getFolderIdAsInt());
        boolean moreThanOneSubscriptionOnThisFolder = this.isThereMoreThanOneSubscriptionOnThisFolder(target.getContext(), target.getFolderId(), null);
        for (FolderUpdaterService<?> updater : this.folderUpdaters) {
            if (!updater.handles(folder)) continue;
            if (moreThanOneSubscriptionOnThisFolder && updater.usesMultipleStrategy()) {
                return updater;
            }
            if (moreThanOneSubscriptionOnThisFolder || updater.usesMultipleStrategy()) continue;
            return updater;
        }
        for (FolderUpdaterService<?> updater : this.folderUpdaters) {
            if (!updater.handles(folder)) continue;
            return updater;
        }
        return null;
    }

    protected FolderObject getFolder(TargetFolderSession subscriptionSession, int contextId, int folderId) throws OXException {
        OXFolderAccess ofa = new OXFolderAccess(this.contextService.getContext(contextId));
        return ofa.getFolderObject(folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSubscription(ServerSession session, int subscriptionId) throws OXException {
        if (!SubscriptionExecutionServiceImpl.tryLock(subscriptionId, (Session)session)) {
            return 0;
        }
        try {
            Context context = session.getContext();
            SubscriptionSource source = this.discoverer.getSource(context, subscriptionId);
            if (source == null) {
                throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
            }
            SubscribeService subscribeService = source.getSubscribeService();
            Subscription subscription = subscribeService.loadSubscription(context, subscriptionId, null);
            subscription.setSession(session);
            boolean knowsSource = this.discoverer.filter(subscription.getUserId(), context.getContextId()).knowsSource(subscribeService.getSubscriptionSource().getId());
            if (!knowsSource) {
                throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
            }
            subscribeService.touch(session.getContext(), subscriptionId);
            SearchIterator<?> data = subscribeService.loadContent(subscription);
            this.storeData(data, subscription, null);
            int n = data.size();
            return n;
        }
        finally {
            SubscriptionExecutionServiceImpl.unlock(subscriptionId, (Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSubscriptions(List<Subscription> subscriptionsToRefresh, ServerSession session, Collection<OXException> optErrors) throws OXException {
        int sum = 0;
        for (Subscription subscription : subscriptionsToRefresh) {
            subscription.setSession(session);
            if (!subscription.isEnabled()) {
                LOG.debug("Skipping subscription {} because it is disabled", (Object)subscription.getDisplayName());
                continue;
            }
            int subscriptionId = subscription.getId();
            if (!SubscriptionExecutionServiceImpl.tryLock(subscriptionId, (Session)session)) continue;
            try {
                SubscriptionSource source = subscription.getSource();
                if (source == null) {
                    throw SubscriptionErrorMessage.INACTIVE_SOURCE.create();
                }
                SubscribeService subscribeService = source.getSubscribeService();
                subscribeService.touch(session.getContext(), subscriptionId);
                SearchIterator<?> data = subscribeService.loadContent(subscription);
                try {
                    this.storeData(data, subscription, optErrors);
                    sum += data.size();
                }
                catch (OXException e) {
                    if (null == optErrors) {
                        throw e;
                    }
                    SearchIterator<?> newData = data instanceof SearchIteratorDelegator ? ((SearchIteratorDelegator)data).newSearchIterator() : subscribeService.loadContent(subscription);
                    SearchIterators.close(data);
                    data = null;
                    sum = 0;
                    while (newData.hasNext()) {
                        Object element = newData.next();
                        try {
                            data = new SingleSearchIterator<Object>(element);
                            this.storeData(data, subscription, null);
                            ++sum;
                        }
                        catch (OXException x) {
                            optErrors.add(x);
                        }
                    }
                }
                finally {
                    SearchIterators.close(data);
                }
            }
            finally {
                SubscriptionExecutionServiceImpl.unlock(subscriptionId, (Session)session);
            }
        }
        return sum;
    }

    private boolean isThereMoreThanOneSubscriptionOnThisFolder(Context context, String folder, String secret) throws OXException {
        List<SubscriptionSource> sources = this.discoverer.getSources();
        ArrayList<Subscription> allSubscriptionsOnThisFolder = new ArrayList<Subscription>(10);
        for (SubscriptionSource subscriptionSource : sources) {
            Collection<Subscription> subscriptions = subscriptionSource.getSubscribeService().loadSubscriptions(context, folder, secret);
            if (subscriptions == null) continue;
            allSubscriptionsOnThisFolder.addAll(subscriptions);
        }
        return allSubscriptionsOnThisFolder.size() >= 2;
    }

    private static SubscriptionKey key(int subscriptionId, Session session) {
        return new SubscriptionKey(subscriptionId, session.getUserId(), session.getContextId());
    }

    private static class SingleSearchIterator<E>
    implements SearchIterator<E> {
        private E value;

        SingleSearchIterator(E value) {
            this.value = value;
        }

        public boolean hasNext() {
            return null != this.value;
        }

        public E next() {
            if (null == this.value) {
                throw new NoSuchElementException();
            }
            E retval = this.value;
            this.value = null;
            return retval;
        }

        public void close() {
        }

        public int size() {
            return 1;
        }

        public boolean hasWarnings() {
            return false;
        }

        public void addWarning(OXException warning) {
        }

        public OXException[] getWarnings() {
            return null;
        }
    }

    private static final class SubscriptionKey {
        private final int subscriptionId;
        private final int userId;
        private final int contextId;
        private final int hash;

        SubscriptionKey(int subscriptionId, int userId, int contextId) {
            this.subscriptionId = subscriptionId;
            this.userId = userId;
            this.contextId = contextId;
            int prime = 31;
            int result = 1;
            result = 31 * result + contextId;
            result = 31 * result + subscriptionId;
            this.hash = result = 31 * result + userId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SubscriptionKey)) {
                return false;
            }
            SubscriptionKey other = (SubscriptionKey)obj;
            if (this.contextId != other.contextId) {
                return false;
            }
            if (this.subscriptionId != other.subscriptionId) {
                return false;
            }
            return this.userId == other.userId;
        }

        public String toString() {
            return new StringBuilder(32).append('{').append("subscriptionId=").append(this.subscriptionId).append(", userId=").append(this.userId).append(", contextId=").append(this.contextId).append('}').toString();
        }
    }
}

