/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.helpers;

import com.openexchange.tools.ssl.TrustAllSSLSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class TrustAllAdapter
implements ProtocolSocketFactory {
    private final TrustAllSSLSocketFactory delegate = (TrustAllSSLSocketFactory)TrustAllSSLSocketFactory.getDefault();

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.delegate.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.delegate.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        int timeout = params.getConnectionTimeout();
        if (timeout != 0) {
            Socket socket = this.delegate.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
            return socket;
        }
        Socket socket = this.createSocket(host, port, localAddress, localPort);
        int linger = params.getLinger();
        if (linger == 0) {
            socket.setSoLinger(false, 0);
        } else if (linger > 0) {
            socket.setSoLinger(true, linger);
        }
        socket.setSoTimeout(params.getSoTimeout());
        socket.setTcpNoDelay(params.getTcpNoDelay());
        return socket;
    }
}

