/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.filler;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.filler.CompositionParameters;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.filler.SessionCompositionParameters;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.session.Session;
import com.openexchange.smtp.config.ISMTPProperties;
import com.sun.mail.smtp.SMTPMessage;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public final class SMTPMessageFiller
extends MimeMessageFiller {
    private final ISMTPProperties smtpProperties;

    public SMTPMessageFiller(ISMTPProperties smtpProperties, Session session, Context ctx, UserSettingMail usm) {
        super((CompositionParameters)new SessionCompositionParameters(session, ctx, usm));
        this.smtpProperties = smtpProperties;
    }

    public SMTPMessageFiller(ISMTPProperties smtpProperties, CompositionParameters compositionParameters) {
        super(compositionParameters);
        this.smtpProperties = smtpProperties;
    }

    public void fillMail(ComposedMailMessage mail, SMTPMessage smtpMessage, ComposeType type) throws MessagingException, OXException, IOException {
        if (null != type) {
            mail.setSendType(type);
        }
        this.setMessageHeaders(mail, (MimeMessage)smtpMessage);
        this.setCommonHeaders((MimeMessage)smtpMessage);
        this.fillMailBody(mail, (MimeMessage)smtpMessage, type);
    }

    public void setCommonHeaders(MimeMessage mimeMessage) throws MessagingException, OXException {
        super.setCommonHeaders(mimeMessage);
        if (this.smtpProperties.isSmtpEnvelopeFrom() && mimeMessage instanceof SMTPMessage) {
            ((SMTPMessage)mimeMessage).setEnvelopeFrom(this.compositionParameters.getEnvelopeFrom());
        }
    }
}

