/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.mail.transport.config.MailAccountTransportProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.SMTPProperties;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailAccountSMTPProperties
extends MailAccountTransportProperties
implements ISMTPProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MailAccountSMTPProperties.class);
    private final MailAccount mailAccount;

    public MailAccountSMTPProperties(MailAccount mailAccount) {
        super(mailAccount);
        this.mailAccount = mailAccount;
    }

    @Override
    public String getSmtpAuthEnc() {
        String smtpAuthEncStr = (String)this.properties.get("com.openexchange.smtp.smtpAuthEnc");
        if (null == smtpAuthEncStr) {
            return SMTPProperties.getInstance().getSmtpAuthEnc();
        }
        if (Charset.isSupported(smtpAuthEncStr)) {
            return smtpAuthEncStr;
        }
        String fallback = SMTPProperties.getInstance().getSmtpAuthEnc();
        LOG.error("SMTP Auth Encoding: Unsupported charset \"{}\". Setting to fallback {}", (Object)smtpAuthEncStr, (Object)fallback);
        return fallback;
    }

    @Override
    public int getSmtpConnectionTimeout() {
        String smtpConTimeoutStr = (String)this.properties.get("com.openexchange.smtp.smtpConnectionTimeout");
        if (null == smtpConTimeoutStr) {
            return SMTPProperties.getInstance().getSmtpConnectionTimeout();
        }
        try {
            return Integer.parseInt(smtpConTimeoutStr);
        }
        catch (NumberFormatException e) {
            LOG.error("SMTP Connection Timeout: Invalid value.", (Throwable)e);
            return SMTPProperties.getInstance().getSmtpConnectionTimeout();
        }
    }

    @Override
    public String getSmtpLocalhost() {
        String smtpLocalhostStr = (String)this.properties.get("com.openexchange.smtp.smtpLocalhost");
        if (null == smtpLocalhostStr) {
            return SMTPProperties.getInstance().getSmtpLocalhost();
        }
        return smtpLocalhostStr.length() == 0 || "null".equalsIgnoreCase(smtpLocalhostStr) ? null : smtpLocalhostStr;
    }

    @Override
    public int getSmtpTimeout() {
        String smtpTimeoutStr = (String)this.properties.get("com.openexchange.smtp.smtpTimeout");
        if (null == smtpTimeoutStr) {
            return SMTPProperties.getInstance().getSmtpTimeout();
        }
        try {
            return Integer.parseInt(smtpTimeoutStr);
        }
        catch (NumberFormatException e) {
            LOG.error("SMTP Timeout: Invalid value.", (Throwable)e);
            return SMTPProperties.getInstance().getSmtpTimeout();
        }
    }

    @Override
    public boolean isSmtpAuth() {
        String smtpAuthStr = (String)this.properties.get("com.openexchange.smtp.smtpAuthentication");
        if (null == smtpAuthStr) {
            return SMTPProperties.getInstance().isSmtpAuth();
        }
        return Boolean.parseBoolean(smtpAuthStr);
    }

    @Override
    public boolean isSendPartial() {
        String smtpPartialStr = (String)this.properties.get("com.openexchange.smtp.sendPartial");
        if (null == smtpPartialStr) {
            return SMTPProperties.getInstance().isSendPartial();
        }
        return Boolean.parseBoolean(smtpPartialStr);
    }

    @Override
    public boolean isSmtpEnvelopeFrom() {
        boolean retval;
        if (this.mailAccount.getId() == 0) {
            String smtpEnvFromStr = (String)this.properties.get("com.openexchange.smtp.setSMTPEnvelopeFrom");
            if (null == smtpEnvFromStr) {
                return SMTPProperties.getInstance().isSmtpEnvelopeFrom();
            }
            retval = Boolean.parseBoolean(smtpEnvFromStr);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean isLogTransport() {
        boolean retval;
        if (this.mailAccount.getId() == 0) {
            String tmp = (String)this.properties.get("com.openexchange.smtp.logTransport");
            if (null == tmp) {
                return SMTPProperties.getInstance().isLogTransport();
            }
            retval = Boolean.parseBoolean(tmp);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public String getSSLProtocols() {
        String tmp = (String)this.properties.get("com.openexchange.smtp.ssl.protocols");
        if (null == tmp) {
            return SMTPProperties.getInstance().getSSLProtocols();
        }
        return tmp.trim();
    }

    @Override
    public String getSSLCipherSuites() {
        String tmp = (String)this.properties.get("com.openexchange.smtp.ssl.ciphersuites");
        if (null == tmp) {
            return SMTPProperties.getInstance().getSSLCipherSuites();
        }
        return tmp.trim();
    }
}

