/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.mail.Protocol;
import com.openexchange.mail.api.AbstractProtocolProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DataMailPart;
import com.openexchange.mail.dataobjects.compose.InfostoreDocumentMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.dataobjects.compose.UploadFileMailPart;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.session.Session;
import com.openexchange.smtp.DefaultSMTPTransport;
import com.openexchange.smtp.NoReplySMTPTransport;
import com.openexchange.smtp.SMTPCapabilityCache;
import com.openexchange.smtp.config.SMTPProperties;
import com.openexchange.smtp.config.SMTPSessionProperties;
import com.openexchange.smtp.dataobjects.SMTPBodyPart;
import com.openexchange.smtp.dataobjects.SMTPDataPart;
import com.openexchange.smtp.dataobjects.SMTPDocumentPart;
import com.openexchange.smtp.dataobjects.SMTPFilePart;
import com.openexchange.smtp.dataobjects.SMTPMailMessage;
import com.openexchange.smtp.dataobjects.SMTPReferencedPart;
import java.util.Map;

public final class SMTPProvider
extends TransportProvider {
    public static final Protocol PROTOCOL_SMTP = new Protocol("smtp", "smtps");
    private static final SMTPProvider instance = new SMTPProvider();

    public static SMTPProvider getInstance() {
        return instance;
    }

    private SMTPProvider() {
    }

    protected void startUp() throws OXException {
        super.startUp();
        SMTPCapabilityCache.init();
    }

    protected void shutDown() throws OXException {
        SMTPSessionProperties.resetDefaultSessionProperties();
        SMTPCapabilityCache.tearDown();
        super.shutDown();
    }

    public MailTransport createNewMailTransport(Session session) throws OXException {
        return new DefaultSMTPTransport(session);
    }

    public MailTransport createNewMailTransport(Session session, int accountId) throws OXException {
        return new DefaultSMTPTransport(session, accountId);
    }

    public MailTransport createNewNoReplyTransport(int contextId) throws OXException {
        return new NoReplySMTPTransport(contextId);
    }

    public ComposedMailMessage getNewComposedMailMessage(Session session, Context ctx) throws OXException {
        return new SMTPMailMessage(session, ctx);
    }

    public InfostoreDocumentMailPart getNewDocumentPart(String documentId, Session session) throws OXException {
        return new SMTPDocumentPart(documentId, session);
    }

    public UploadFileMailPart getNewFilePart(UploadFile uploadFile) throws OXException {
        return new SMTPFilePart(uploadFile);
    }

    public ReferencedMailPart getNewReferencedPart(MailPart referencedPart, Session session) throws OXException {
        return new SMTPReferencedPart(referencedPart, session);
    }

    public ReferencedMailPart getNewReferencedMail(MailMessage referencedMail, Session session) throws OXException {
        return new SMTPReferencedPart(referencedMail, session);
    }

    public TextBodyMailPart getNewTextBodyPart(String textBody) throws OXException {
        return new SMTPBodyPart(textBody);
    }

    public Protocol getProtocol() {
        return PROTOCOL_SMTP;
    }

    protected AbstractProtocolProperties getProtocolProperties() {
        return SMTPProperties.getInstance();
    }

    public DataMailPart getNewDataPart(Object data, Map<String, String> dataProperties, Session session) throws OXException {
        return new SMTPDataPart(data, dataProperties, session);
    }
}

