/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.NoReplyConfig;
import com.openexchange.mail.transport.config.NoReplyConfigFactory;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.smtp.AbstractSMTPTransport;
import com.openexchange.smtp.NoReplyCompositionParameters;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.SMTPConfig;
import com.openexchange.smtp.config.SMTPProperties;
import com.openexchange.smtp.filler.SMTPMessageFiller;
import com.openexchange.smtp.services.Services;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoReplySMTPTransport
extends AbstractSMTPTransport {
    private static final Logger LOG = LoggerFactory.getLogger(NoReplySMTPTransport.class);
    private final NoReplyConfig noReplyConfig;

    public NoReplySMTPTransport(int contextId) throws OXException {
        super(contextId);
        NoReplyConfigFactory configFactory = Services.getService(NoReplyConfigFactory.class);
        if (configFactory == null) {
            throw ServiceExceptionCode.serviceUnavailable(NoReplyConfigFactory.class);
        }
        this.noReplyConfig = configFactory.getNoReplyConfig(contextId);
    }

    @Override
    protected void setReplyHeaders(MimeMessage mimeMessage, MailPath msgref) throws OXException, MessagingException {
        throw new OXException((Throwable)new IllegalAccessException("Replies cannot be send by no-reply transport"));
    }

    @Override
    protected SMTPMessageFiller createSMTPMessageFiller() throws OXException {
        return new SMTPMessageFiller(this.getTransportConfig().getSMTPProperties(), new NoReplyCompositionParameters());
    }

    @Override
    protected SMTPConfig createSMTPConfig() throws OXException {
        SMTPConfig smtpConfig = new SMTPConfig();
        smtpConfig.setLogin(this.noReplyConfig.getLogin());
        smtpConfig.setPassword(this.noReplyConfig.getPassword());
        smtpConfig.setServer(this.noReplyConfig.getServer());
        smtpConfig.setPort(this.noReplyConfig.getPort());
        NoReplyConfig.SecureMode secureMode = this.noReplyConfig.getSecureMode();
        smtpConfig.setRequireTls(NoReplyConfig.SecureMode.TLS.equals((Object)secureMode));
        smtpConfig.setSecure(NoReplyConfig.SecureMode.SSL.equals((Object)secureMode));
        smtpConfig.setTransportProperties(new NoReplySMTPProperties());
        return smtpConfig;
    }

    @Override
    protected void processAddressHeader(MimeMessage mimeMessage) throws OXException, MessagingException {
        super.processAddressHeader(mimeMessage);
        mimeMessage.setFrom((Address)this.noReplyConfig.getAddress());
        mimeMessage.setSender(null);
        mimeMessage.setReplyTo(null);
    }

    @Override
    protected Session getSMTPSession() throws OXException {
        return this.getSMTPSession(this.getTransportConfig(), false);
    }

    public void sendReceiptAck(MailMessage srcMail, String fromAddr) throws OXException {
        throw new OXException((Throwable)new IllegalAccessException("Receipts cannot be send by no-reply transport"));
    }

    protected ITransportProperties createNewMailProperties() throws OXException {
        return TransportProperties.getInstance();
    }

    private final class NoReplySMTPProperties
    implements ISMTPProperties {
        private final TransportProperties serverProperties;
        private final SMTPProperties smtpProperties = SMTPProperties.getInstance();

        private NoReplySMTPProperties() {
            this.serverProperties = TransportProperties.getInstance();
        }

        public int getReferencedPartLimit() {
            return this.serverProperties.getReferencedPartLimit();
        }

        @Override
        public boolean isSmtpEnvelopeFrom() {
            return false;
        }

        @Override
        public boolean isSmtpAuth() {
            return !Strings.isEmpty((String)NoReplySMTPTransport.this.noReplyConfig.getLogin()) && !Strings.isEmpty((String)NoReplySMTPTransport.this.noReplyConfig.getPassword());
        }

        @Override
        public boolean isLogTransport() {
            return true;
        }

        @Override
        public boolean isSendPartial() {
            return this.smtpProperties.isSendPartial();
        }

        @Override
        public int getSmtpTimeout() {
            return this.smtpProperties.getSmtpTimeout();
        }

        @Override
        public String getSmtpLocalhost() {
            return this.smtpProperties.getSmtpLocalhost();
        }

        @Override
        public int getSmtpConnectionTimeout() {
            return this.smtpProperties.getSmtpConnectionTimeout();
        }

        @Override
        public String getSmtpAuthEnc() {
            return this.smtpProperties.getSmtpAuthEnc();
        }

        @Override
        public String getSSLProtocols() {
            return this.smtpProperties.getSSLProtocols();
        }

        @Override
        public String getSSLCipherSuites() {
            return this.smtpProperties.getSSLCipherSuites();
        }

        public boolean isEnforceSecureConnection() {
            return false;
        }

        public void setEnforceSecureConnection(boolean enforceSecureConnection) {
        }
    }
}

