/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.exception.OXException;
import com.openexchange.mail.transport.listener.MailTransportListener;
import com.openexchange.mail.transport.listener.Reply;
import com.openexchange.mail.transport.listener.Result;
import com.openexchange.osgi.ServiceListing;
import com.openexchange.session.Session;
import java.util.List;
import javax.mail.internet.MimeMessage;

public class ListenerChain
implements MailTransportListener {
    private static volatile ListenerChain instance;
    private final ServiceListing<MailTransportListener> listeners;

    public static ListenerChain getInstance() {
        return instance;
    }

    public static synchronized void initInstance(ServiceListing<MailTransportListener> listing) {
        if (null == instance) {
            instance = new ListenerChain(listing);
        }
    }

    public static synchronized void releaseInstance() {
        instance = null;
    }

    private ListenerChain(ServiceListing<MailTransportListener> listeners) {
        this.listeners = listeners;
    }

    public Result onBeforeMessageTransport(MimeMessage message, Session session) throws OXException {
        List listeners = this.listeners.getServiceList();
        if (null == listeners || listeners.isEmpty()) {
            return new ChainResult(message, Reply.NEUTRAL);
        }
        for (MailTransportListener listener : listeners) {
            Result result = listener.onBeforeMessageTransport(message, session);
            Reply reply = result.getReply();
            if (Reply.DENY != reply && Reply.ACCEPT != reply) continue;
            return result;
        }
        return new ChainResult(message, Reply.NEUTRAL);
    }

    public void onAfterMessageTransport(MimeMessage message, Exception exception, Session session) throws OXException {
        List listeners = this.listeners.getServiceList();
        if (null == listeners || listeners.isEmpty()) {
            return;
        }
        for (MailTransportListener listener : listeners) {
            listener.onAfterMessageTransport(message, exception, session);
        }
    }

    private static class ChainResult
    implements Result {
        private final MimeMessage mimeMessage;
        private final Reply reply;

        ChainResult(MimeMessage mimeMessage, Reply reply) {
            this.mimeMessage = mimeMessage;
            this.reply = reply;
        }

        public Reply getReply() {
            return this.reply;
        }

        public MimeMessage getMimeMessage() {
            return this.mimeMessage;
        }
    }
}

