/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.share;

import com.google.common.io.BaseEncoding;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import java.util.Iterator;
import java.util.List;

public class ShareTargetPath {
    private final int module;
    private final String folder;
    private final String item;

    public ShareTargetPath(int module, String folder, String item) {
        this.module = module;
        this.folder = folder;
        this.item = item;
    }

    public int getModule() {
        return this.module;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getItem() {
        return this.item;
    }

    public boolean isFolder() {
        return this.item == null;
    }

    public String get() {
        StringBuilder sb = new StringBuilder(64).append("/");
        String version = "1";
        sb.append(version).append('/');
        sb.append(this.module).append('/');
        sb.append(ShareTargetPath.encodeFolder(version, this.folder));
        if (this.item != null) {
            sb.append('/').append(ShareTargetPath.encodeItem(version, this.item));
        }
        return sb.toString();
    }

    public static ShareTargetPath parse(String path) {
        List segments = Strings.splitAndTrim((String)path, (String)"/");
        Iterator iterator = segments.iterator();
        while (iterator.hasNext()) {
            if (!Strings.isEmpty((String)((String)iterator.next()))) continue;
            iterator.remove();
        }
        return ShareTargetPath.parse(segments);
    }

    public static ShareTargetPath parse(List<String> segments) {
        try {
            Iterator<String> it = segments.iterator();
            String version = it.next();
            int module = Integer.parseInt(it.next());
            String folder = ShareTargetPath.decodeFolder(version, it.next());
            String item = null;
            if (it.hasNext()) {
                item = ShareTargetPath.decodeItem(version, it.next());
            }
            if (!it.hasNext()) {
                return new ShareTargetPath(module, folder, item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String encodeFolder(String version, String folder) {
        if ("1".equals(version)) {
            return ShareTargetPath.base64(folder, true);
        }
        throw new IllegalArgumentException("Unknown encoding version: " + version);
    }

    private static String decodeFolder(String version, String folder) {
        if ("1".equals(version)) {
            return ShareTargetPath.base64(folder, false);
        }
        throw new IllegalArgumentException("Unknown encoding version: " + version);
    }

    private static String encodeItem(String version, String item) {
        if ("1".equals(version)) {
            return ShareTargetPath.base64(item, true);
        }
        throw new IllegalArgumentException("Unknown encoding version: " + version);
    }

    private static String decodeItem(String version, String item) {
        if ("1".equals(version)) {
            return ShareTargetPath.base64(item, false);
        }
        throw new IllegalArgumentException("Unknown encoding version: " + version);
    }

    private static String base64(String input, boolean encode) {
        if (input == null) {
            return null;
        }
        if (encode) {
            return BaseEncoding.base64Url().omitPadding().encode(input.getBytes(Charsets.UTF_8));
        }
        return new String(BaseEncoding.base64Url().omitPadding().decode((CharSequence)input), Charsets.UTF_8);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + this.module;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShareTargetPath other = (ShareTargetPath)obj;
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        return this.module == other.module;
    }

    public String toString() {
        return this.get();
    }
}

