/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.behaviour;

import com.openexchange.consistency.ConsistencyExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.behaviour.Behaviour;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class UserAgentBehaviour
implements Behaviour {
    private Map<Class<? extends Object>, Object> classes = null;
    private Pattern pattern;

    public UserAgentBehaviour(String userAgentPattern, Object ... implementations) throws OXException {
        this.setPattern(userAgentPattern);
        this.setChanges(new HashSet<Object>(Arrays.asList(implementations)));
    }

    public UserAgentBehaviour() {
    }

    public void setPattern(String userAgentPattern) {
        this.pattern = Pattern.compile(userAgentPattern);
    }

    public void setChanges(Set<Object> implementations) throws OXException {
        this.classes = new HashMap<Class<? extends Object>, Object>();
        for (Object object : implementations) {
            for (Class<?> addMe = object.getClass(); addMe != null; addMe = addMe.getSuperclass()) {
                Class<?>[] interfaces;
                for (Class<?> iFace : interfaces = addMe.getInterfaces()) {
                    if (this.classes.get(iFace) != null) {
                        throw ConsistencyExceptionCodes.REGISTRATION_FAILED.create("Two implemenations for " + iFace);
                    }
                    this.classes.put(iFace, object);
                }
            }
        }
    }

    public void setChange(Object implementation) throws OXException {
        this.setChanges(new HashSet<Object>(Arrays.asList(implementation)));
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return (T)this.classes.get(clazz);
    }

    @Override
    public boolean matches(WebdavRequest req) {
        if (req.getHeader("user-agent") == null) {
            return false;
        }
        return this.pattern.matcher(req.getHeader("user-agent")).find();
    }

    @Override
    public Set<Class<? extends Object>> provides() {
        return this.classes.keySet();
    }

    public String toString() {
        return "UserAgent matcher: " + this.pattern.toString();
    }
}

