/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.tools.arrays.Collections;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.CapturingWebdavResponse;
import com.openexchange.webdav.action.ReplayWebdavRequest;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavLogAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavLogAction.class);
    private static final Set<String> CONFIDENTIAL_HEADERS = Collections.unmodifiableSet((Object[])new String[]{"AUTHORIZATION"});
    private boolean logBody;
    private boolean logResponse;

    public WebdavLogAction() {
    }

    public WebdavLogAction(boolean logBody, boolean logResponse) {
        this.logBody = logBody;
        this.logResponse = logResponse;
    }

    public void setLogRequestBody(boolean b) {
        this.logBody = b;
    }

    public void setLogResponseBody(boolean b) {
        this.logResponse = b;
    }

    @Override
    public void perform(WebdavRequest request, WebdavResponse response) throws WebdavProtocolException {
        try {
            if (!LOG.isDebugEnabled()) {
                this.yield(request, response);
                return;
            }
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder(8192);
            stringBuilder.append("URL: ").append(request.getUrl()).append(lineSeparator);
            for (String header : request.getHeaderNames()) {
                stringBuilder.append(header).append(": ").append(CONFIDENTIAL_HEADERS.contains(header.toUpperCase()) ? "***" : request.getHeader(header)).append(lineSeparator);
            }
            WebdavResource resource = request.getResource();
            if (null != resource) {
                stringBuilder.append("Resource: ").append(resource).append(lineSeparator);
                stringBuilder.append("exists: ").append(resource.exists()).append(lineSeparator);
                stringBuilder.append("isCollection: ").append(resource.isCollection()).append(lineSeparator);
            }
            LOG.debug(stringBuilder.toString());
            stringBuilder = null;
            CapturingWebdavResponse capturingResponse = null;
            if (LOG.isTraceEnabled()) {
                if (this.logBody) {
                    request = new ReplayWebdavRequest(request);
                    WebdavLogAction.logRequestBody(request, lineSeparator);
                }
                if (this.logResponse) {
                    capturingResponse = new CapturingWebdavResponse(response);
                    response = capturingResponse;
                }
            }
            this.yield(request, response);
            if (null != capturingResponse) {
                LOG.trace(capturingResponse.getBodyAsString());
            }
        }
        catch (WebdavProtocolException e) {
            if (500 == e.getStatus()) {
                LOG.error("HTTP {} ({}) for request {}", new Object[]{e.getStatus(), e.getMessage(), request.getUrl(), e});
            } else {
                LOG.debug("HTTP {} ({}) for request {}", new Object[]{e.getStatus(), e.getMessage(), request.getUrl(), e});
            }
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Unexepected runtime excpetion handling request {}: {}", new Object[]{request.getUrl(), e.getMessage(), e});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logRequestBody(WebdavRequest req, String lineSeparator) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(req.getBody(), Charsets.UTF_8));
            String line = null;
            StringBuilder b = new StringBuilder(65536);
            while ((line = reader.readLine()) != null) {
                b.append(line);
                b.append(lineSeparator);
            }
            LOG.trace(b.toString());
            Streams.close((Closeable)reader);
        }
        catch (IOException x) {
            LOG.debug("", (Throwable)x);
        }
        finally {
            Streams.close(reader);
        }
    }
}

