/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.configuration.SystemConfig;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.facade.impl.EventFiringInfostoreFacadeImpl;
import com.openexchange.groupware.infostore.paths.impl.PathResolverImpl;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.InMemoryAliases;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.groupware.infostore.webdav.TouchInfoitemsWithExpiredLocksListener;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.OXWebdavMaxUploadSizeAction;
import com.openexchange.webdav.action.OXWebdavPutAction;
import com.openexchange.webdav.action.ServletWebdavRequest;
import com.openexchange.webdav.action.ServletWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavCopyAction;
import com.openexchange.webdav.action.WebdavDefaultHeaderAction;
import com.openexchange.webdav.action.WebdavDeleteAction;
import com.openexchange.webdav.action.WebdavExistsAction;
import com.openexchange.webdav.action.WebdavGetAction;
import com.openexchange.webdav.action.WebdavHeadAction;
import com.openexchange.webdav.action.WebdavIfAction;
import com.openexchange.webdav.action.WebdavIfMatchAction;
import com.openexchange.webdav.action.WebdavLockAction;
import com.openexchange.webdav.action.WebdavLogAction;
import com.openexchange.webdav.action.WebdavMkcolAction;
import com.openexchange.webdav.action.WebdavMoveAction;
import com.openexchange.webdav.action.WebdavOptionsAction;
import com.openexchange.webdav.action.WebdavPropfindAction;
import com.openexchange.webdav.action.WebdavProppatchAction;
import com.openexchange.webdav.action.WebdavRequestCycleAction;
import com.openexchange.webdav.action.WebdavTraceAction;
import com.openexchange.webdav.action.WebdavUnlockAction;
import com.openexchange.webdav.action.behaviour.BehaviourLookup;
import com.openexchange.webdav.action.behaviour.RequestSpecificBehaviourRegistry;
import com.openexchange.webdav.action.behaviour.UserAgentBehaviour;
import com.openexchange.webdav.action.ifheader.IgnoreLocksIfHeaderApply;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.xml.spring.SpringParser;
import java.io.File;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;

public final class InfostorePerformer
implements SessionHolder {
    private static final Logger LOG = LoggerFactory.getLogger(InfostorePerformer.class);
    private static final InfostorePerformer INSTANCE = new InfostorePerformer();
    private final InfostoreWebdavFactory factory;
    private final Protocol protocol = new Protocol();
    private final Map<Action, WebdavAction> actions = new EnumMap<Action, WebdavAction>(Action.class);
    private final ThreadLocal<ServerSession> session = new ThreadLocal();
    private static volatile Action[] NULL_TOLERANT_ACTIONS;

    public static InfostorePerformer getInstance() {
        return INSTANCE;
    }

    private InfostorePerformer() {
        InMemoryAliases aliases = new InMemoryAliases();
        Locale locale = new Locale("en", "US");
        aliases.registerNameWithIDAndParent(FolderObject.getFolderString(10, locale), 10, 9);
        aliases.registerNameWithIDAndParent(FolderObject.getFolderString(15, locale), 15, 9);
        InfostoreWebdavFactory infoFactory = new InfostoreWebdavFactory();
        EventFiringInfostoreFacadeImpl database = new EventFiringInfostoreFacadeImpl();
        infoFactory.setDatabase(database);
        infoFactory.setFolderLockManager(new FolderLockManagerImpl());
        infoFactory.setFolderProperties(new PropertyStoreImpl("oxfolder_property"));
        EntityLockManagerImpl infoLockManager = new EntityLockManagerImpl("infostore_lock");
        infoLockManager.addExpiryListener(new TouchInfoitemsWithExpiredLocksListener(this, database));
        infoFactory.setInfoLockManager(infoLockManager);
        infoFactory.setLockNullLockManager(new EntityLockManagerImpl("lock_null_lock"));
        infoFactory.setInfoProperties(new PropertyStoreImpl("infostore_property"));
        infoFactory.setProvider(new DBPoolProvider());
        PathResolverImpl resolver = new PathResolverImpl(infoFactory.getDatabase());
        resolver.setAliases(aliases);
        infoFactory.setResolver(resolver);
        infoFactory.setSecurity(new InfostoreSecurityImpl());
        infoFactory.setSessionHolder(this);
        infoFactory.setAliases(aliases);
        this.factory = infoFactory;
        WebdavAction unlock = this.prepare(new WebdavUnlockAction(), true, true, new WebdavIfAction(0, false, false));
        WebdavAction propPatch = this.prepare(new WebdavProppatchAction(this.protocol), true, true, new WebdavExistsAction(), new WebdavIfAction(0, true, false));
        WebdavAction propFind = this.prepare(new WebdavPropfindAction(this.protocol), true, true, new WebdavExistsAction(), new WebdavIfAction(0, false, false));
        WebdavAction options = this.prepare(new WebdavOptionsAction(), true, true, new WebdavIfAction(0, false, false));
        WebdavAction move = this.prepare(new WebdavMoveAction(infoFactory), true, true, new WebdavExistsAction(), new WebdavIfAction(0, true, true));
        WebdavAction mkcol = this.prepare(new WebdavMkcolAction(), true, true, new WebdavIfAction(0, true, false));
        WebdavAction lock = this.prepare(new WebdavLockAction(), true, true, new WebdavIfAction(0, true, false));
        WebdavAction copy = this.prepare(new WebdavCopyAction(infoFactory), true, true, new WebdavExistsAction(), new WebdavIfAction(0, false, true));
        WebdavAction delete = this.prepare(new WebdavDeleteAction(), true, true, new WebdavExistsAction(), new WebdavIfAction(0, true, false));
        WebdavAction get = this.prepare(new WebdavGetAction(), true, false, new WebdavExistsAction(), new WebdavIfAction(0, false, false));
        WebdavAction head = this.prepare(new WebdavHeadAction(), true, true, new WebdavExistsAction(), new WebdavIfAction(0, false, false));
        OXWebdavPutAction oxWebdavPut = new OXWebdavPutAction();
        oxWebdavPut.setSessionHolder(this);
        OXWebdavMaxUploadSizeAction oxWebdavMaxUploadSize = new OXWebdavMaxUploadSizeAction(this);
        WebdavAction put = this.prepare(oxWebdavPut, false, true, new WebdavIfAction(0, false, false), oxWebdavMaxUploadSize);
        WebdavAction trace = this.prepare(new WebdavTraceAction(), true, true, new WebdavIfAction(0, false, false));
        this.actions.put(Action.UNLOCK, unlock);
        this.actions.put(Action.PROPPATCH, propPatch);
        this.actions.put(Action.PROPFIND, propFind);
        this.actions.put(Action.OPTIONS, options);
        this.actions.put(Action.MOVE, move);
        this.actions.put(Action.MKCOL, mkcol);
        this.actions.put(Action.LOCK, lock);
        this.actions.put(Action.COPY, copy);
        this.actions.put(Action.DELETE, delete);
        this.actions.put(Action.GET, get);
        this.actions.put(Action.HEAD, head);
        this.actions.put(Action.PUT, put);
        this.actions.put(Action.TRACE, trace);
        this.makeLockNullTolerant();
        this.loadRequestSpecificBehaviourRegistry();
    }

    private void makeLockNullTolerant() {
        Action[] tmp = NULL_TOLERANT_ACTIONS;
        if (null == tmp) {
            tmp = new Action[]{Action.OPTIONS, Action.LOCK, Action.MKCOL, Action.PUT};
            NULL_TOLERANT_ACTIONS = tmp;
        }
        for (Action action : tmp) {
            WebdavAction webdavAction = this.actions.get((Object)action);
            while (webdavAction != null) {
                if (webdavAction instanceof WebdavExistsAction) {
                    ((WebdavExistsAction)webdavAction).setTolerateLockNull(true);
                    webdavAction = null;
                    continue;
                }
                if (webdavAction instanceof AbstractAction) {
                    webdavAction = ((AbstractAction)webdavAction).getNext();
                    continue;
                }
                webdavAction = null;
            }
        }
    }

    private void loadRequestSpecificBehaviourRegistry() {
        RequestSpecificBehaviourRegistry registry;
        String beanPath = SystemConfig.getProperty(SystemConfig.Property.WebdavOverrides);
        if (beanPath != null && new File(beanPath).exists()) {
            SpringParser springParser = ServerServiceRegistry.getInstance().getService(SpringParser.class);
            BeanFactory beanfactory = springParser.parseFile(beanPath, InfostorePerformer.class.getClassLoader());
            registry = (RequestSpecificBehaviourRegistry)beanfactory.getBean("registry");
        } else {
            registry = new RequestSpecificBehaviourRegistry();
        }
        try {
            registry.add(new UserAgentBehaviour("Microsoft Data Access Internet Publishing Provider DAV", new IgnoreLocksIfHeaderApply()));
        }
        catch (OXException e) {
            LOG.error("Can't add default overrides", (Throwable)e);
        }
        registry.log();
        BehaviourLookup.getInstance().setRegistry(registry);
    }

    private WebdavAction prepare(AbstractAction action, boolean logBody, boolean logResponse, AbstractAction ... additionals) {
        WebdavLogAction logAction = new WebdavLogAction();
        logAction.setLogRequestBody(logBody);
        logAction.setLogResponseBody(logResponse);
        WebdavRequestCycleAction lifeCycle = new WebdavRequestCycleAction();
        WebdavDefaultHeaderAction defaultHeader = new WebdavDefaultHeaderAction();
        WebdavIfMatchAction ifMatch = new WebdavIfMatchAction();
        lifeCycle.setNext(logAction);
        logAction.setNext(defaultHeader);
        defaultHeader.setNext(ifMatch);
        AbstractAction a = ifMatch;
        for (AbstractAction a2 : additionals) {
            a.setNext(a2);
            a = a2;
        }
        a.setNext(action);
        return lifeCycle;
    }

    @Override
    public ServerSession getSessionObject() {
        this.sessionNotNull();
        return this.session.get();
    }

    private void sessionNotNull() {
        if (this.session.get() == null) {
            IllegalStateException exc = new IllegalStateException();
            LOG.error("No session found in Session holder", exc.fillInStackTrace());
        }
    }

    @Override
    public Context getContext() {
        return this.session.get().getContext();
    }

    @Override
    public User getUser() {
        return this.session.get().getUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(HttpServletRequest req, HttpServletResponse resp, Action action, ServerSession sess) {
        try {
            ServletWebdavRequest webdavRequest = new ServletWebdavRequest(this.factory, req);
            ServletWebdavResponse webdavResponse = new ServletWebdavResponse(resp);
            this.session.set(sess);
            BehaviourLookup.getInstance().setRequest(webdavRequest);
            LOG.debug("Executing {}", (Object)action);
            this.actions.get((Object)action).perform(webdavRequest, webdavResponse);
        }
        catch (WebdavProtocolException x) {
            resp.setStatus(x.getStatus());
        }
        catch (OXException x) {
            LOG.error("Error detected.", (Throwable)x);
        }
        catch (NullPointerException x) {
            LOG.error("Null reference detected.", (Throwable)x);
        }
        finally {
            BehaviourLookup.getInstance().unsetRequest();
            this.session.set(null);
        }
    }

    public InfostoreWebdavFactory getFactory() {
        return this.factory;
    }

    public static enum Action {
        UNLOCK,
        PROPPATCH,
        PROPFIND,
        OPTIONS,
        MOVE,
        MKCOL,
        LOCK,
        COPY,
        DELETE,
        GET,
        HEAD,
        PUT,
        TRACE;

    }
}

