/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.webdav;

import com.openexchange.java.Strings;
import com.openexchange.tools.servlet.http.Authorization;

public class AuthorizationHeader {
    private final String value;
    private final String scheme;
    private final String authString;

    private AuthorizationHeader(String value, String scheme, String authString) {
        this.value = value;
        this.scheme = scheme;
        this.authString = authString;
    }

    public static AuthorizationHeader parse(String headerValue) throws IllegalArgumentException {
        if (headerValue == null) {
            throw new IllegalArgumentException("Invalid authorization header: null");
        }
        String scheme = Authorization.extractAuthScheme(headerValue).trim();
        if (Strings.isEmpty((String)scheme)) {
            throw new IllegalArgumentException("Invalid authorization header: " + headerValue);
        }
        try {
            String authString = headerValue.substring(headerValue.indexOf(scheme) + scheme.length() + 1);
            return new AuthorizationHeader(headerValue, scheme, authString);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid authorization header: " + headerValue);
        }
    }

    public static AuthorizationHeader parseSafe(String headerValue) {
        try {
            AuthorizationHeader header = AuthorizationHeader.parse(headerValue);
            return header;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getRawValue() {
        return this.value;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAuthString() {
        return this.authString;
    }
}

