/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum OXFolderExceptionCode implements DisplayableOXExceptionCode
{
    NO_MODULE_ACCESS("User %1$s has no access to module %2$s in context %3$s due to user configuration", "You do not have appropriate permissions for module \"%2$s\".", Category.CATEGORY_PERMISSION_DENIED, 2, OXException.Generic.NO_PERMISSION),
    NOT_VISIBLE("Folder \"%1$s\" not visible to user %2$s in context %3$s", "You do not have appropriate permissions to view the folder.", Category.CATEGORY_PERMISSION_DENIED, 3, OXException.Generic.NO_PERMISSION),
    NO_SHARED_FOLDER_ACCESS("User %1$s has no access on shared folder %2$s in context %3$s due to user configuration", "Shared folders are not available for your account.", Category.CATEGORY_PERMISSION_DENIED, 4, OXException.Generic.NO_PERMISSION),
    NO_PUBLIC_FOLDER_WRITE_ACCESS("User %1$s has no write access on public folder %2$s in context %3$s due to user configuration", "You do not have appropriate permissions for the public folder.", Category.CATEGORY_PERMISSION_DENIED, 5, OXException.Generic.NO_PERMISSION),
    NO_CREATE_SUBFOLDER_PERMISSION("User %1$s has no create-subfolder permission on folder %2$s in context %3$s", "You do not have appropriate permissions to create subfolders.", Category.CATEGORY_PERMISSION_DENIED, 6, OXException.Generic.NO_PERMISSION),
    MISSING_FOLDER_ATTRIBUTE("Missing field %1$s in folder %2$s in context %3$s", "You must enter a folder name.", Category.CATEGORY_USER_INPUT, 7),
    NOT_EXISTS("Folder %1$s does not exist in context %2$s", "Such a folder does not exist.", Category.CATEGORY_ERROR, 8, OXException.Generic.NOT_FOUND),
    CONCURRENT_MODIFICATION("Folder %1$s has been modified after last sync timestamp in context %2$s", "The folder has been changed in the meantime. Please reload the view and try again.", Category.CATEGORY_CONFLICT, 9, OXException.Generic.CONFLICT),
    NO_ADMIN_ACCESS("User %1$s has no admin access to folder %2$s in context %3$s", "This operation requires administrative permissions for the folder.", Category.CATEGORY_PERMISSION_DENIED, 10, OXException.Generic.NO_PERMISSION),
    NO_DEFAULT_FOLDER_RENAME("Default folder %1$s cannot be renamed in context %2$s", "The folder is a default folder and cannot be renamed.", Category.CATEGORY_PERMISSION_DENIED, 11, OXException.Generic.NO_PERMISSION),
    NO_DUPLICATE_FOLDER("A duplicate folder exists in parent folder %1$s in context %2$s", "The folder already contains a folder with such a name.", Category.CATEGORY_PERMISSION_DENIED, 12),
    INVALID_TYPE("Parent folder %1$s does not allow type %2$s in context %3$s", "Folders of type \"%2$s\" can't be created below this folder.", Category.CATEGORY_ERROR, 13),
    INVALID_MODULE("Parent folder %1$s does not allow module %2$s in context %3$s", "Folders of module \"%2$s\" can't be created below this folder.", Category.CATEGORY_ERROR, 14),
    ONLY_ONE_PRIVATE_FOLDER_ADMIN("Only one admin permission is allowed on a private folder", "Only one user may have administrative permission roles in a private folder.", Category.CATEGORY_ERROR, 15),
    NO_PRIVATE_FOLDER_ADMIN_GROUP("A group must not hold admin permission on a private folder", "Administrative permissions for a group are not allowed in a private folder.", Category.CATEGORY_ERROR, 16),
    ONLY_PRIVATE_FOLDER_OWNER_ADMIN("Only folder owner may hold admin permission on a private folder", "Only the owner of a private folder may hold administrative permissions.", Category.CATEGORY_ERROR, 17),
    NO_FOLDER_ADMIN("Administration rights required. In the Rights tab add at least one user with administration rights.", "At least one user with administrative permissions is required.", Category.CATEGORY_ERROR, 18),
    INVALID_OBJECT_ID("Invalid object ID %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 19),
    NO_MOVE_THROUGH_UPDATE("Not allowed to change parent id of folder %1$s through an update call. Use move method instead.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 20),
    NO_DEFAULT_FOLDER_MOVE("Not allowed to move default folder %1$s in context %2$s", "The folder is a default folder and cannot be moved.", Category.CATEGORY_PERMISSION_DENIED, 21),
    NO_SHARED_FOLDER_MOVE("Shared folder %1$s cannot be moved in context %2$s", "The folder is shared and cannot be moved.", Category.CATEGORY_PERMISSION_DENIED, 23),
    NO_SHARED_FOLDER_TARGET("Shared folder %1$s cannot be target of move operation in context %2$s", "The folder cannot be moved to a shared folder.", Category.CATEGORY_PERMISSION_DENIED, 24),
    NO_SYSTEM_FOLDER_MOVE("System folder %1$s cannot be moved in context %2$s", "The folder is a system folder and cannot be moved.", Category.CATEGORY_PERMISSION_DENIED, 25),
    ONLY_PRIVATE_TO_PRIVATE_MOVE("Private folder %1$s can only be moved to a private folder in context %2$s", "The private folder can only be moved to another private folder.", Category.CATEGORY_PERMISSION_DENIED, 26),
    ONLY_PUBLIC_TO_PUBLIC_MOVE("Public folder %1$s can only be moved to a public folder in context %2$s", "The public folder can only be moved to another public folder.", Category.CATEGORY_PERMISSION_DENIED, 27),
    NO_EQUAL_MOVE("Target and source folder cannot be equal in context %1$s", "The destination folder is the same as the source folder.", Category.CATEGORY_PERMISSION_DENIED, 28),
    NO_SUBFOLDER_MOVE_ACCESS("User %1$s is not allowed to move all subfolders of folder %2$s in context %3$s", "You do not have appropriate permissions to move all subfolders.", Category.CATEGORY_PERMISSION_DENIED, 29),
    NO_SHARED_FOLDER_DELETION("User %1$s is not allowed to delete shared folder %2$s in context %3$s", "You do not have appropriate permissions to delete the shared folder.", Category.CATEGORY_PERMISSION_DENIED, 30),
    NO_DEFAULT_FOLDER_DELETION("User %1$s is not allowed to delete default folder %2$s in context %3$s", "The folder is a default folder and cannot be deleted.", Category.CATEGORY_PERMISSION_DENIED, 31),
    NOT_ALL_OBJECTS_DELETION("User %1$s is not allowed to delete all objects in folder %2$s in context %3$s", "You do not have appropriate permissions to delete all contained items.", Category.CATEGORY_PERMISSION_DENIED, 32),
    NO_ADMIN_USER_FOUND_IN_CONTEXT("No admin user found in context %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 33),
    NO_DEFAULT_FOLDER_FOUND("No default folder could be found in module %1$s for user %2$s in context %3$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 34),
    FOLDER_COULD_NOT_BE_LOADED("Folder %1$s could not be loaded in context %2$s", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 35),
    FOLDER_COULD_NOT_BE_PUT_INTO_CACHE("Folder %1$s could not be put into cache in context %2$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 36),
    NO_EFFECTIVE_PERMISSION("Effective permission of folder %1$s could not be determined for user %2$s in context %3$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 37),
    SQL_ERROR("A SQL error occurred: %1$s", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 38),
    DBPOOLING_ERROR("A DBPool error occurred in context %1$s", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 39),
    INVALID_SEQUENCE_ID("Delivered sequence id %1$s from database is less than allowed min. folder id of %2$s in context %3$s", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 41),
    UNKNOWN_MODULE("Module %1$s is unknown in context %2$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 42),
    INVALID_ENTITY("Invalid entity id %1$s detected in permissions of folder %2$s in context %3$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 44),
    INVALID_ENTITY_FROM_USER("Invalid entity id %1$s (%2$s) detected in permissions of folder %3$s in context %4$s", "You are not allowed to share the folder to \"%2$s\"", Category.CATEGORY_USER_INPUT, INVALID_ENTITY.getNumber()),
    NO_SUBFOLDER_MOVE("Folder %1$s must not be moved to one of its subfolders in context %2$s", "The folder cannot be be moved to one of its subfolders.", Category.CATEGORY_ERROR, 45),
    UNKNOWN_EXCEPTION("An unexpected error occurred: %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 46),
    LDAP_ERROR("A LDAP error occurred in context %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 47),
    ATTRIBUTE_NOT_SET("Attribute \"%1$s\" is not set in FolderObject instance %2$s in context %3$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 48),
    INCOMPATIBLE_MODULES("A source folder of module %1$s must not be moved to a target folder of module %2$s", "Folders of module \"%1$s\" cannot be moved to folders of module \"%2$s\".", Category.CATEGORY_PERMISSION_DENIED, 49),
    FOLDER_CACHE_INITIALIZATION_FAILED("Folder cache (region name = %1$s) could not be initialized due to the following reason: %2$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 51),
    CACHE_NOT_ENABLED("Folder cache has not been enabled in config file 'foldercache.properties'", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 52),
    CACHE_ERROR_ON_REMOVE("Folder %1$s could not be removed from folder cache", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 53),
    JSON_ERROR("A JSON error occurred: %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 55),
    UNKNOWN_PARAMETER_CONTAINER_TYPE("Unknown parameter container type: %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 56),
    MISSING_PARAMETER("Missing parameter %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 57),
    BAD_PARAM_VALUE("Bad value %1$s in parameter %2$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_USER_INPUT, 58),
    UNKNOWN_FIELD("Unknown field: %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 59),
    PARAMETER_MISMATCH("Parameter %1$s does not match JSON key %2$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 60),
    INVALID_PERMISSION("Invalid permission values: fp=%1$s orp=%2$s owp=%3$s odp=%4$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 61),
    UNKNOWN_ACTION("Unknown action: %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 62),
    NO_SHARED_FOLDER_UPDATE("Shared folder %1$s must not be updated in context %2$s", "The shared folder cannot be updated.", Category.CATEGORY_PERMISSION_DENIED, 63),
    TRUNCATED("The value for attribute %1$s contains more than the allowed number of %2$d characters. Current length: %3$d characters.", "The value for attribute %1$s contains more than the allowed number of %2$d characters. Current length: %3$d characters.", Category.CATEGORY_TRUNCATED, 64),
    TRUNCATED_FOLDERNAME("The value for attribute %1$s contains more than the allowed number of %2$d characters. Current length: %3$d characters.", "The specified folder name exceeds the limit of %2$d characters. Please shorten the name and try again.", Category.CATEGORY_TRUNCATED, 64),
    MAP_PERMISSION_FAILED("Unable to map OCL permission value %1$s to a JSON permission value", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 65),
    UNSUFFICIENT_FOLDER_INFORMATION("Folder existence cannot be checked due to insufficient folder information", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 66),
    RUNTIME_ERROR("A runtime error occurred in context %1$s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 67),
    INVALID_SHARED_FOLDER_SUBFOLDER_PERMISSION("User %1$s granted invalid permissions on shared folder %2$s in context %3$s. Only the owner of the parent shared folder %4$s can administrate the folder.", "Only the owner of the parent shared folder may hold administrative permissions.", Category.CATEGORY_PERMISSION_DENIED, 70),
    CREATOR_IS_NOT_ADMIN("Owner %1$s of default folder %2$s must keep the folder admin permission", "The folder is a default folder. Hence its owner needs to hold administrative permissions.", Category.CATEGORY_USER_INPUT, 71),
    SHARE_FORBIDDEN("User %1$s is not allowed to share folder %2$s in context %3$s due to user configuration", "You do not have appropriate permissions to share the folder.", Category.CATEGORY_PERMISSION_DENIED, 72),
    UNAPPLICABLE_FOLDER_PERM("The permissions for the user %1$s are limited. It is not possible to grant this user the wanted permissions for the folder %2$s in context %3$s.", "It is not possible to apply the changes due to limited permissions", Category.CATEGORY_PERMISSION_DENIED, 73),
    HIDDEN_FOLDER_ON_DELETION("Folder %1$s in context %2$s contains a hidden subfolder. User %3$s has no delete rights for this subfolder and consequently cannot delete its parent folder.", "The folder cannot be deleted since it contains a hidden subfolder you don't have the appropriate permissions for.", Category.CATEGORY_PERMISSION_DENIED, 74),
    NO_DEFAULT_INFOSTORE_CREATE("An infostore folder named %1$s already exists below folder %2$s (%3$s) in context %4$s. Please choose another display name.", "The folder already contains a folder with such a name. Please choose a different name and try again.", Category.CATEGORY_PERMISSION_DENIED, 75),
    INVALID_DATA("Folder contains invalid data: \"%1$s\"", "The folder name contains invalid characters.", Category.CATEGORY_USER_INPUT, 76),
    SIMILAR_NAMED_SHARED_FOLDER("You already share a personal folder named \"%1$s\" with the same user. You can not share two folders with exactly the same name with a user. Please rename the folder before sharing it with this user.", "You already share a personal folder named \"%1$s\" with the same user. You can not share two folders with exactly the same name with a user. Please rename the folder before sharing it with this user.", Category.CATEGORY_USER_INPUT, 77),
    NO_FOLDER_MODULE_UPDATE("Folder module cannot be updated since folder is not empty", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_USER_INPUT, 78),
    DUPLICATE_USER_PERMISSION("Duplicate permission defined for user %1$s. Only one permission per user is allowed.", "Duplicate permission defined. Only one permission per user is allowed.", Category.CATEGORY_USER_INPUT, 79),
    DUPLICATE_GROUP_PERMISSION("Duplicate permission defined for group %1$s. Only one permission per group is allowed.", "Duplicate permission defined. Only one permission per group is allowed.", Category.CATEGORY_USER_INPUT, 80),
    FOLDER_VISIBILITY_PERMISSION_ONLY("Only the folder visibility permission is allowed to be changed for folder %1$s in context %2$s.", "Only the folder visibility permission is allowed to be changed.", Category.CATEGORY_PERMISSION_DENIED, 81),
    NO_GROUP_PERMISSION("Only individual user permissions, but no group permissions are allowed for folder %1$s in context %2$s.", "Only individual user permissions, but no group permissions are allowed.", Category.CATEGORY_PERMISSION_DENIED, 82),
    NO_INDIVIDUAL_PERMISSION("No individual user permissions are allowed for folder %1$s in context %2$s.", "No individual user permissions are allowed.", Category.CATEGORY_PERMISSION_DENIED, 83),
    DENY_FOLDER_MODULE_UPDATE("Folder module must not be updated.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_USER_INPUT, 84),
    NO_DEFAULT_FOLDER_MODULE_UPDATE("The module of a default folder must not be changed.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_USER_INPUT, 85),
    NO_RENAME_ACCESS("User %1$s must not rename folder %2$s in context %3$s", "You do not have appropriate permissions to rename the folder.", Category.CATEGORY_PERMISSION_DENIED, 86),
    CREATE_FAILED("Failed to create folder. Please retry.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_TRY_AGAIN, 87),
    DELETE_FAILED_LOCKED_DOCUMENTS("Delete cannot be performed because of locked documents in folder %1$s in context %2$s.", "The folder cannot be deleted as it contains locked documents.", Category.CATEGORY_PERMISSION_DENIED, 88),
    ADMIN_OP_ONLY("Operation may only be performed for context administrator.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_PERMISSION_DENIED, 89),
    DELETE_DENIED("Folder %1$s must not be deleted in context %2$s.", "The folder cannot be deleted.", Category.CATEGORY_PERMISSION_DENIED, 90),
    CREATOR_STAYS_ADMIN("Owner %1$s of folder %2$s has been restored to keep the folder admin permission", "The administrative permissions were restored.", Category.CATEGORY_WARNING, 91),
    INVALID_CHARACTER("Unsupported character \"%1$s\" in field \"%2$s\".", "Unsupported character \"%1$s\" in field \"%2$s\". Please remove that character.", CATEGORY_USER_INPUT, 92),
    INVALID_CHARACTER_SIMPLE("Unsupported character", "Unsupported character. Please correct your input.", CATEGORY_USER_INPUT, 92),
    NO_RESERVED_FOLDER("The folder name \"%1$s\" is reserved. Please choose another name.", "The folder name \"%1$s\" is reserved. Please choose another name.", Category.CATEGORY_PERMISSION_DENIED, 93);

    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int number;
    private final OXException.Generic generic;

    public static boolean isNotFound(OXException e) {
        return NOT_EXISTS.getPrefix().equals(e.getPrefix()) && NOT_EXISTS.getNumber() == e.getCode();
    }

    private OXFolderExceptionCode(String message, String displayMessage, Category category, int number) {
        this(message, displayMessage, category, number, OXException.Generic.NONE);
    }

    private OXFolderExceptionCode(String message, String displayMessage, Category category, int number, OXException.Generic generic) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.category = category;
        this.number = number;
        this.generic = generic;
    }

    public String getPrefix() {
        return "FLD";
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

