/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.scheduler;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SchedulerUncaughtExceptionhandler
implements Thread.UncaughtExceptionHandler {
    private static final SchedulerUncaughtExceptionhandler INSTANCE = new SchedulerUncaughtExceptionhandler();

    static SchedulerUncaughtExceptionhandler getInstance() {
        return INSTANCE;
    }

    private SchedulerUncaughtExceptionhandler() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Logger LOG = LoggerFactory.getLogger(SchedulerUncaughtExceptionhandler.class);
        LOG.error("Thread terminated with exception: {}", (Object)t.getName(), (Object)e);
        Map<Thread, StackTraceElement[]> stackMap = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder(256);
        String lineSeparator = System.getProperty("line.separator");
        for (Thread thread : stackMap.keySet()) {
            sb.append(thread.getName()).append(" ID:").append(thread.getId());
            sb.append(" State:").append((Object)thread.getState()).append(" Prio:").append(thread.getPriority());
            sb.append(lineSeparator);
            SchedulerUncaughtExceptionhandler.appendStackTrace(stackMap.get(thread), sb, lineSeparator);
            sb.append(lineSeparator);
        }
        LOG.error(sb.toString());
    }

    private static void appendStackTrace(StackTraceElement[] trace, StringBuilder sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>\n");
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }
}

