/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.java.Strings;
import com.openexchange.tools.images.ScaleType;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTransformationUtility {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTransformationUtility.class);
    private static final String COVER = ScaleType.COVER.getKeyword();

    private ImageTransformationUtility() {
    }

    public static boolean seemsLikeThumbnailRequest(AJAXRequestData requestData) {
        return COVER.equals(requestData.getParameter("scaleType")) || "thumbnail_image".equals(requestData.getFormat());
    }

    public static boolean seemsLikeThumbnailRequest(HttpServletRequest request) {
        return COVER.equals(request.getParameter("scaleType")) || "thumbnail_image".equals(request.getParameter("format"));
    }

    public static String getImageFormat(String value) {
        int idx;
        if (null == value) {
            LOG.debug("No format name specified, falling back to 'jpeg'.");
            return "jpeg";
        }
        String val = value;
        if (val.toLowerCase().startsWith("image/")) {
            val = val.substring(6);
        }
        if (0 < (idx = val.indexOf(59))) {
            val = val.substring(0, idx);
        }
        if ("pjpeg".equals(val)) {
            LOG.debug("Assuming 'jpeg' for image format {}", (Object)val);
            return "jpeg";
        }
        if ("x-png".equals(val)) {
            LOG.debug("Assuming 'png' for image format {}", (Object)val);
            return "png";
        }
        if ("x-ms-bmp".equals(val)) {
            LOG.debug("Assuming 'bmp' for image format {}", (Object)val);
            return "bmp";
        }
        return val;
    }

    public static boolean canRead(String formatName) {
        String tmp = Strings.toLowerCase((CharSequence)formatName);
        if ("vnd.microsoft.icon".equals(tmp) || "x-icon".equals(tmp)) {
            return false;
        }
        for (String readerFormatName : ImageIO.getReaderFormatNames()) {
            if (!Strings.toLowerCase((CharSequence)readerFormatName).equals(tmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsTransparency(String formatName) {
        return false == "jpeg".equalsIgnoreCase(formatName) && false == "jpg".equalsIgnoreCase(formatName);
    }
}

