/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CSVWriter {
    private static final char ROW_DELIMITER = '\n';
    private static final char CELL_DELIMITER = ',';
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<List<Object>> data;
    private final PrintStream ps;

    public CSVWriter(PrintStream ps, List<List<Object>> data) {
        this.ps = ps;
        this.data = data;
    }

    public void write() {
        StringBuilder sb = new StringBuilder();
        for (List<Object> row : this.data) {
            for (Object entry : row) {
                sb.append(this.quote(CSVWriter.toString(entry)));
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, '\n');
            this.ps.print(sb.toString());
            sb.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            DateFormat dateFormat = DATE_FORMAT;
            synchronized (dateFormat) {
                return DATE_FORMAT.format((Date)obj);
            }
        }
        return obj.toString();
    }

    private String quote(String s) {
        StringBuilder tmp = new StringBuilder();
        tmp.append('\"');
        tmp.append(s.replaceAll("\"", "\"\""));
        tmp.append('\"');
        return tmp.toString();
    }
}

