/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.authorization.Authorization;
import com.openexchange.authorization.AuthorizationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCustomizer
implements ServiceTrackerCustomizer<AuthorizationService, AuthorizationService> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationCustomizer.class);
    private final BundleContext context;

    public AuthorizationCustomizer(BundleContext context) {
        this.context = context;
    }

    public AuthorizationService addingService(ServiceReference<AuthorizationService> reference) {
        AuthorizationService auth = (AuthorizationService)this.context.getService(reference);
        if (null == Authorization.getService()) {
            Authorization.setService(auth);
            return auth;
        }
        this.context.ungetService(reference);
        LOG.error("Several authorization services found. Remove all except one!");
        return null;
    }

    public void modifiedService(ServiceReference<AuthorizationService> reference, AuthorizationService service) {
    }

    public void removedService(ServiceReference<AuthorizationService> reference, AuthorizationService service) {
        if (Authorization.dropService(service)) {
            LOG.error("Removed authorization service was not active!");
        } else {
            this.context.ungetService(reference);
        }
    }
}

