/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordchange;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.guest.GuestService;
import com.openexchange.java.Strings;
import com.openexchange.passwordchange.BasicPasswordChangeService;
import com.openexchange.passwordchange.PasswordChangeEvent;
import com.openexchange.passwordmechs.IPasswordMech;
import com.openexchange.passwordmechs.PasswordMechFactory;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.user.UserService;

public class DefaultBasicPasswordChangeService
extends BasicPasswordChangeService {
    @Override
    protected void update(PasswordChangeEvent event) throws OXException {
        GuestService guestService;
        Context ctx = event.getContext();
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class);
        if (userService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{UserService.class.getName()});
        }
        User user = userService.getUser(event.getSession().getUserId(), ctx);
        UserImpl updatedUser = new UserImpl(user);
        this.prepareUserUpdate(event, user, updatedUser);
        userService.updatePassword(updatedUser, ctx);
        userService.invalidateUser(ctx, event.getSession().getUserId());
        if (updatedUser.isGuest() && (guestService = ServerServiceRegistry.getInstance().getService(GuestService.class)) != null) {
            guestService.updateGuestUser(updatedUser, ctx.getContextId());
        }
    }

    protected void prepareUserUpdate(PasswordChangeEvent event, User user, UserImpl updatedUser) throws OXException {
        if (Strings.isEmpty((String)event.getNewPassword())) {
            updatedUser.setUserPassword(null);
        } else {
            PasswordMechFactory passwordMechFactory = ServerServiceRegistry.getInstance().getService(PasswordMechFactory.class);
            IPasswordMech iPasswordMech = passwordMechFactory.get("{BCRYPT}");
            if (Strings.isNotEmpty((String)user.getPasswordMech())) {
                iPasswordMech = passwordMechFactory.get(user.getPasswordMech());
            }
            updatedUser.setPasswordMech(iPasswordMech.getIdentifier());
            updatedUser.setUserPassword(iPasswordMech.encode(event.getNewPassword()));
        }
    }
}

