/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum MailAccountExceptionCodes implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR("Unexpected error: %1$s.", CATEGORY_ERROR, 1),
    NOT_FOUND("Cannot find mail account with identifier %1$s for user %2$s in context %3$s.", CATEGORY_ERROR, 2, "Cannot find mail account for user \"%2$s\"."),
    CONFLICT("Found two mail accounts with same identifier %1$s for user %2$s in context %3$s.", CATEGORY_CONFLICT, 3, "Found two mail accounts with same identifier %1$s for user %2$s."),
    SQL_ERROR("A SQL error occurred: %1$s.", CATEGORY_ERROR, 4, "Error while reading/writing data from/to the database."),
    UNKNOWN_HOST_ERROR("A host could not be resolved: %1$s.", CATEGORY_ERROR, 5, "A host could not be resolved: %1$s."),
    NO_DEFAULT_DELETE("Denied deletion of default mail account of user %1$s in context %2$s.", CATEGORY_PERMISSION_DENIED, 6, "You do not have the appropriate permissions to delete the default mail account."),
    NO_DEFAULT_UPDATE("Denied update of default mail account of user %1$s in context %2$s.", CATEGORY_PERMISSION_DENIED, 7, "You do not have the appropriate permissions to update the default mail account."),
    NO_DEFAULT_UPDATE_ATTR("Denied update of attribute %1$s for default mail account of user %2$s in context %3$s.", CATEGORY_PERMISSION_DENIED, 7, "You do not have the appropriate permissions to update the default mail account."),
    NO_DUPLICATE_DEFAULT("No duplicate default account allowed.", CATEGORY_USER_INPUT, 8, "The default mail account already exists."),
    PASSWORD_ENCRYPTION_FAILED("Password encryption failed for login %1$s on server %2$s (user=%3$s, context=%4$s).", CATEGORY_ERROR, 9),
    PASSWORD_DECRYPTION_FAILED("Password decryption failed for login %1$s on server %2$s (user=%3$s, context=%4$s).", CATEGORY_ERROR, 10),
    DUPLICATE_UNIFIED_INBOX_ACCOUNT("The Unified Mail account already exists for user %1$s in context %2$s.", CATEGORY_USER_INPUT, 11, "The Unified Mail account already exists."),
    UNIFIED_INBOX_ACCOUNT_CREATION_FAILED("It is not allowed to create a new mail account for Unified Mail with id %1$s.", CATEGORY_USER_INPUT, 12, "It is not allowed to create a new mail account for Unified Mail."),
    UNIFIED_INBOX_ACCOUNT_VALIDATION_FAILED("Validation for Unified Mail account failed.", CATEGORY_USER_INPUT, 13, "Validation for Unified Mail failed."),
    NOT_ENABLED("Multiple mail accounts not enabled for user %1$s in context %2$s.", CATEGORY_PERMISSION_DENIED, 14, "You do not have the appropriate permissions to create more than one mail account."),
    CONFLICT_ADDR("Found two mail accounts with same E-Mail address %1$s for user %2$s in context %3$s.", CATEGORY_USER_INPUT, 15, "A mail account with the given E-Mail address already exists."),
    INVALID_NAME("Invalid mail account name: %1$s", CATEGORY_USER_INPUT, 16, "The mail account name \"%1$s\" is not valid."),
    DUPLICATE_MAIL_ACCOUNT("Duplicate mail account for user %1$s in context %2$s.", CATEGORY_USER_INPUT, 17, "The selected mail account name already exists."),
    DUPLICATE_TRANSPORT_ACCOUNT("Duplicate transport account for user %1$s in context %2$s.", CATEGORY_ERROR, 17, "Duplicate transport account for user %1$s in context %2$s."),
    URI_PARSE_FAILED("Unable to parse mail server URI \"%1$s\".", CATEGORY_ERROR, 18, "The given host name \"%1$s\" is invalid."),
    INVALID_HOST_NAME("Invalid host name: %1$s", CATEGORY_USER_INPUT, 19, "The given host name \"%1$s\" is invalid."),
    VALIDATE_FAILED_MAIL("Could not connect to mail server \"%1$s\" for login %2$s", CATEGORY_WARNING, 20, "Could not connect to mail server \"%1$s\" for login %2$s. Please review your settings."),
    VALIDATE_FAILED_TRANSPORT("Could not connect to transport server \"%1$s\" for login %2$s", CATEGORY_WARNING, 21, "Could not connect to transport server \"%1$s\" for login %2$s. Please review your settings."),
    DEFAULT_BUT_SECURE_MAIL("Default port specified for mail protocol \"%1$s\", but SSL is enabled. Please review if appropriate.", CATEGORY_WARNING, 22, "Default port specified for mail protocol \"%1$s\", but SSL is enabled. Please review if appropriate."),
    SECURE_BUT_DEFAULT_MAIL("Secure port specified for mail protocol \"%1$s\", but SSL is not enabled. Please review if appropriate.", CATEGORY_WARNING, 23, "Secure port specified for mail protocol \"%1$s\", but SSL is not enabled. Please review if appropriate."),
    DEFAULT_BUT_SECURE_TRANSPORT("Default port specified for transport protocol \"%1$s\", but SSL is enabled. Please review if appropriate.", CATEGORY_WARNING, 24, "Default port specified for transport protocol \"%1$s\", but SSL is enabled. Please review if appropriate."),
    SECURE_BUT_DEFAULT_TRANSPORT("Secure port specified for transport protocol \"%1$s\", but SSL is not enabled. Please review if appropriate.", CATEGORY_WARNING, 25, "Secure port specified for transport protocol \"%1$s\", but SSL is not enabled. Please review if appropriate."),
    BLACKLISTED_SERVER("Mail account creation denied. The host/server name \"%1$s\" is covered by specified IP range back-list.", CATEGORY_WARNING, 25, "The given host name \"%1$s\" is not allowed."),
    PROTOCOL_CHANGE("The protocol must not changed from %1$s to %2$s for user %3$s in context %4$s.", CATEGORY_USER_INPUT, 26, "The protocol must not changed from %1$s to %2$s.");

    private static final String PREFIX = "ACC";
    private static final String UNEXPECTED_ERROR_MSG = "Unexpected error: %1$s.";
    private static final String PROTOCOL_CHANGE_MSG = "The protocol must not changed from %1$s to %2$s for user %3$s in context %4$s.";
    private static final String NOT_FOUND_MSG = "Cannot find mail account with identifier %1$s for user %2$s in context %3$s.";
    private static final String CONFLICT_MSG = "Found two mail accounts with same identifier %1$s for user %2$s in context %3$s.";
    private static final String SQL_ERROR_MSG = "A SQL error occurred: %1$s.";
    private static final String UNKNOWN_HOST_ERROR_MSG = "A host could not be resolved: %1$s.";
    private static final String NO_DEFAULT_DELETE_MSG = "Denied deletion of default mail account of user %1$s in context %2$s.";
    private static final String NO_DUPLICATE_DEFAULT_MSG = "No duplicate default account allowed.";
    private static final String PASSWORD_ENCRYPTION_FAILED_MSG = "Password encryption failed for login %1$s on server %2$s (user=%3$s, context=%4$s).";
    private static final String PASSWORD_DECRYPTION_FAILED_MSG = "Password decryption failed for login %1$s on server %2$s (user=%3$s, context=%4$s).";
    private static final String DUPLICATE_UNIFIED_INBOX_ACCOUNT_MSG = "The Unified Mail account already exists for user %1$s in context %2$s.";
    private static final String UNIFIED_INBOX_ACCOUNT_CREATION_FAILED_MSG = "It is not allowed to create a new mail account for Unified Mail with id %1$s.";
    private static final String UNIFIED_INBOX_ACCOUNT_VALIDATION_FAILED_MSG = "Validation for Unified Mail account failed.";
    private static final String NOT_ENABLED_MSG = "Multiple mail accounts not enabled for user %1$s in context %2$s.";
    private static final String CONFLICT_ADDR_MSG = "Found two mail accounts with same E-Mail address %1$s for user %2$s in context %3$s.";
    private static final String INVALID_NAME_MSG = "Invalid mail account name: %1$s";
    private static final String DUPLICATE_MAIL_ACCOUNT_MSG = "Duplicate mail account for user %1$s in context %2$s.";
    private static final String DUPLICATE_TRANSPORT_ACCOUNT_MSG = "Duplicate transport account for user %1$s in context %2$s.";
    private static final String URI_PARSE_FAILED_MSG = "Unable to parse mail server URI \"%1$s\".";
    private static final String INVALID_HOST_NAME_MSG = "Invalid host name: %1$s";
    private static final String VALIDATE_FAILED_MAIL_MSG = "Could not connect to mail server \"%1$s\" for login %2$s";
    private static final String VALIDATE_FAILED_TRANSPORT_MSG = "Could not connect to transport server \"%1$s\" for login %2$s";
    private static final String DEFAULT_BUT_SECURE_MAIL_MSG = "Default port specified for mail protocol \"%1$s\", but SSL is enabled. Please review if appropriate.";
    private static final String SECURE_BUT_DEFAULT_MAIL_MSG = "Secure port specified for mail protocol \"%1$s\", but SSL is not enabled. Please review if appropriate.";
    private static final String DEFAULT_BUT_SECURE_TRANSPORT_MSG = "Default port specified for transport protocol \"%1$s\", but SSL is enabled. Please review if appropriate.";
    private static final String SECURE_BUT_DEFAULT_TRANSPORT_MSG = "Secure port specified for transport protocol \"%1$s\", but SSL is not enabled. Please review if appropriate.";
    private static final String BLACKLISTED_SERVER_MSG = "Mail account creation denied. The host/server name \"%1$s\" is covered by specified IP range back-list.";
    private final String message;
    private final Category category;
    private final int number;
    private String displayMessage;

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    private MailAccountExceptionCodes(String message, Category category, int number) {
        this(message, category, number, null);
    }

    private MailAccountExceptionCodes(String message, Category category, int number, String displayMessage) {
        this.message = message;
        this.category = category;
        this.number = number;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

