/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.java.Strings;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultFolderNamesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFolderNamesProvider.class);
    private static final String SWITCH_DEFAULT_FOLDER = "Switching to default value %s";
    private final FallbackProvider fallbackProvider;
    public static final FallbackProvider DEFAULT_PROVIDER = new FallbackProvider(){

        @Override
        public String getConfirmedHam() {
            return MailStrings.CONFIRMED_HAM;
        }

        @Override
        public String getConfirmedSpam() {
            return MailStrings.CONFIRMED_SPAM;
        }

        @Override
        public String getDrafts() {
            return MailStrings.DRAFTS;
        }

        @Override
        public String getSent() {
            return MailStrings.SENT;
        }

        @Override
        public String getSpam() {
            return MailStrings.SPAM;
        }

        @Override
        public String getTrash() {
            return MailStrings.TRASH;
        }
    };

    public DefaultFolderNamesProvider(int accountId, int user, int cid) throws OXException {
        if (0 == accountId) {
            this.fallbackProvider = DEFAULT_PROVIDER;
        } else {
            MailAccountStorageService storageService = ServerServiceRegistry.getServize(MailAccountStorageService.class, true);
            this.fallbackProvider = new DefaultAccountFallbackProvider(storageService.getDefaultMailAccount(user, cid));
        }
    }

    public String[] getDefaultFolderNames(MailAccount mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderNames(mailAccount.getTrash(), mailAccount.getSent(), mailAccount.getDrafts(), mailAccount.getSpam(), mailAccount.getConfirmedSpam(), mailAccount.getConfirmedHam(), isSpamEnabled);
    }

    public String[] getDefaultFolderNames(MailAccountDescription mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderNames(mailAccount.getTrash(), mailAccount.getSent(), mailAccount.getDrafts(), mailAccount.getSpam(), mailAccount.getConfirmedSpam(), mailAccount.getConfirmedHam(), isSpamEnabled);
    }

    public String[] getDefaultFolderNames(MailConfig mailConfig, boolean isSpamEnabled) {
        String[] standardNames = mailConfig.getStandardNames();
        return this.getDefaultFolderNames(standardNames[3], standardNames[1], standardNames[0], standardNames[2], standardNames[4], standardNames[5], isSpamEnabled);
    }

    public String[] getDefaultFolderNames(String trash, String sent, String drafts, String spam, String confirmedSpam, String confirmedHam, boolean isSpamEnabled) {
        String[] names = new String[isSpamEnabled ? 6 : 4];
        if (drafts == null || drafts.length() == 0) {
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getDrafts()));
            names[0] = this.fallbackProvider.getDrafts();
        } else {
            names[0] = drafts;
        }
        if (sent == null || sent.length() == 0) {
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getSent()));
            names[1] = this.fallbackProvider.getSent();
        } else {
            names[1] = sent;
        }
        if (spam == null || spam.length() == 0) {
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getSpam()));
            names[2] = this.fallbackProvider.getSpam();
        } else {
            names[2] = spam;
        }
        if (trash == null || trash.length() == 0) {
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getTrash()));
            names[3] = this.fallbackProvider.getTrash();
        } else {
            names[3] = trash;
        }
        if (isSpamEnabled) {
            if (confirmedSpam == null || confirmedSpam.length() == 0) {
                LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getConfirmedSpam()));
                names[4] = this.fallbackProvider.getConfirmedSpam();
            } else {
                names[4] = confirmedSpam;
            }
            if (confirmedHam == null || confirmedHam.length() == 0) {
                LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getConfirmedHam()));
                names[5] = this.fallbackProvider.getConfirmedHam();
            } else {
                names[5] = confirmedHam;
            }
        }
        return names;
    }

    public String[] getDefaultFolderFullnames(MailAccount mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderFullnames(DefaultFolderNamesProvider.extractFullname(mailAccount.getTrashFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSentFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getDraftsFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedHamFullname()), isSpamEnabled);
    }

    public String[] getDefaultFolderFullnames(MailAccountDescription mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderFullnames(DefaultFolderNamesProvider.extractFullname(mailAccount.getTrashFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSentFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getDraftsFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedHamFullname()), isSpamEnabled);
    }

    public static String extractFullname(String fullnameParameter) {
        return null == fullnameParameter ? null : MailFolderUtility.prepareMailFolderParam(fullnameParameter).getFullname();
    }

    public String[] getDefaultFolderFullnames(MailConfig mailConfig, boolean isSpamEnabled) {
        String[] standardFullNames = mailConfig.getStandardFullNames();
        return this.getDefaultFolderFullnames(standardFullNames[3], standardFullNames[1], standardFullNames[0], standardFullNames[2], standardFullNames[4], standardFullNames[5], isSpamEnabled);
    }

    public String[] getDefaultFolderFullnames(String trashFullname, String sentFullname, String draftsFullname, String spamFullname, String confirmedSpamFullname, String confirmedHamFullname, boolean isSpamEnabled) {
        String[] fullnames = new String[isSpamEnabled ? 6 : 4];
        fullnames[0] = Strings.isEmpty((String)draftsFullname) ? null : draftsFullname;
        fullnames[1] = Strings.isEmpty((String)sentFullname) ? null : sentFullname;
        fullnames[2] = Strings.isEmpty((String)spamFullname) ? null : spamFullname;
        fullnames[3] = Strings.isEmpty((String)trashFullname) ? null : trashFullname;
        if (isSpamEnabled) {
            fullnames[4] = Strings.isEmpty((String)confirmedSpamFullname) ? null : confirmedSpamFullname;
            fullnames[5] = Strings.isEmpty((String)confirmedHamFullname) ? null : confirmedHamFullname;
        }
        return fullnames;
    }

    private static final class DefaultAccountFallbackProvider
    implements FallbackProvider {
        private final MailAccount defaultAccount;

        public DefaultAccountFallbackProvider(MailAccount defaultAccount) {
            this.defaultAccount = defaultAccount;
        }

        @Override
        public String getConfirmedHam() {
            String ret = this.defaultAccount.getConfirmedHam();
            if (Strings.isEmpty((String)ret)) {
                return DEFAULT_PROVIDER.getConfirmedHam();
            }
            return ret;
        }

        @Override
        public String getConfirmedSpam() {
            String ret = this.defaultAccount.getConfirmedSpam();
            if (Strings.isEmpty((String)ret)) {
                return DEFAULT_PROVIDER.getConfirmedSpam();
            }
            return ret;
        }

        @Override
        public String getDrafts() {
            String ret = this.defaultAccount.getDrafts();
            if (Strings.isEmpty((String)ret)) {
                return DEFAULT_PROVIDER.getDrafts();
            }
            return ret;
        }

        @Override
        public String getSent() {
            String ret = this.defaultAccount.getSent();
            if (Strings.isEmpty((String)ret)) {
                return DEFAULT_PROVIDER.getSent();
            }
            return ret;
        }

        @Override
        public String getSpam() {
            String ret = this.defaultAccount.getSpam();
            if (Strings.isEmpty((String)ret)) {
                return DEFAULT_PROVIDER.getSpam();
            }
            return ret;
        }

        @Override
        public String getTrash() {
            String ret = this.defaultAccount.getTrash();
            if (Strings.isEmpty((String)ret)) {
                return DEFAULT_PROVIDER.getTrash();
            }
            return ret;
        }
    }

    public static interface FallbackProvider {
        public String getTrash();

        public String getSent();

        public String getDrafts();

        public String getSpam();

        public String getConfirmedSpam();

        public String getConfirmedHam();
    }
}

