/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Set;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.search.NotTerm;

public final class NOTTerm
extends SearchTerm<SearchTerm<?>> {
    private static final long serialVersionUID = 2984060879603969678L;
    private SearchTerm<?> term;

    protected NOTTerm() {
        this.term = null;
    }

    public NOTTerm(SearchTerm<?> term) {
        this.term = term;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SearchTerm<?> getPattern() {
        return this.term;
    }

    public void setTerm(SearchTerm term) {
        this.term = term;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        this.term.addMailField(col);
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new NotTerm(this.term.getJavaMailSearchTerm());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new NotTerm(this.term.getNonWildcardJavaMailSearchTerm());
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        this.term.contributeTo(fetchProfile);
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        return !this.term.matches(msg);
    }

    @Override
    public boolean matches(MailMessage mailMessage) throws OXException {
        return !this.term.matches(mailMessage);
    }

    @Override
    public SearchTerm<?> filter(Set<Class<? extends SearchTerm>> filterSet) {
        return this.term.filter(filterSet);
    }

    @Override
    public boolean isAscii() {
        return this.term.isAscii();
    }

    @Override
    public boolean containsWildcard() {
        return this.term.containsWildcard();
    }
}

